/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

public class DownloadAuthorization {
    private static final DownloadAuthorization APPROVED = new DownloadAuthorization(Result.Approved, null);
    private final Result result;
    private final String explanation;

    private DownloadAuthorization(Result result, String explanation) {
        if (Result.Denied.equals((Object)result) && explanation == null) {
            throw new IllegalArgumentException("An explanation is required when the download request is denied.");
        }
        this.result = result;
        this.explanation = explanation;
    }

    public boolean isApproved() {
        return Result.Approved.equals((Object)this.result);
    }

    public String getExplanation() {
        return this.explanation;
    }

    public static DownloadAuthorization approved() {
        return APPROVED;
    }

    public static DownloadAuthorization denied(String explanation) {
        return new DownloadAuthorization(Result.Denied, explanation);
    }

    private static enum Result {
        Approved,
        Denied;

    }
}

