/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.provenance.search.SearchTerm;

public class Query {
    private final String identifier;
    private final List<SearchTerm> searchTerms = new ArrayList<SearchTerm>();
    private Date startDate;
    private Date endDate;
    private String minFileSize;
    private String maxFileSize;
    private int maxResults = 1000;

    public Query(String identifier) {
        this.identifier = Objects.requireNonNull(identifier);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void addSearchTerm(SearchTerm searchTerm) {
        this.searchTerms.add(searchTerm);
    }

    public List<SearchTerm> getSearchTerms() {
        return Collections.unmodifiableList(this.searchTerms);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public void setMinFileSize(String fileSize) {
        this.minFileSize = fileSize;
    }

    public String getMinFileSize() {
        return this.minFileSize;
    }

    public void setMaxFileSize(String fileSize) {
        this.maxFileSize = fileSize;
    }

    public String getMaxFileSize() {
        return this.maxFileSize;
    }

    public String toString() {
        return "Query[ " + this.searchTerms + " ]";
    }
}

