/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.apache.nifi.registry.MultiMapVariableRegistry;

abstract class FileVariableRegistry
extends MultiMapVariableRegistry {
    FileVariableRegistry() {
    }

    FileVariableRegistry(File ... files) throws IOException {
        this.addVariables(files);
    }

    FileVariableRegistry(Path ... paths) throws IOException {
        this.addVariables(paths);
    }

    private void addVariables(File ... files) throws IOException {
        if (files != null) {
            for (File file : files) {
                this.registry.addMap(this.convertFile(file));
            }
        }
    }

    private void addVariables(Path ... paths) throws IOException {
        if (paths != null) {
            for (Path path : paths) {
                this.registry.addMap(this.convertFile(path.toFile()));
            }
        }
    }

    protected abstract Map<String, String> convertFile(File var1) throws IOException;
}

