/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiMap<V>
implements Map<String, V> {
    private final List<Map<String, V>> maps = new ArrayList<Map<String, V>>();

    MultiMap() {
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        for (Map<String, V> map : this.maps) {
            if (map.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        for (Map<String, V> map : this.maps) {
            if (!map.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map<String, V> map : this.maps) {
            if (!map.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Null Keys are not allowed");
        }
        for (Map<String, V> map : this.maps) {
            V val = map.get(key);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    @Override
    public V put(String key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keySet = new HashSet<String>();
        for (Map<String, V> map : this.maps) {
            keySet.addAll(map.keySet());
        }
        return keySet;
    }

    @Override
    public Collection<V> values() {
        HashSet<V> values = new HashSet<V>();
        for (Map<String, V> map : this.maps) {
            values.addAll(map.values());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        HashSet<Map.Entry<String, V>> entrySet = new HashSet<Map.Entry<String, V>>();
        for (Map<String, V> map : this.maps) {
            entrySet.addAll(map.entrySet());
        }
        return entrySet;
    }

    void addMap(Map<String, V> map) {
        this.maps.add(map);
    }
}

