/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry;

import java.util.Map;
import java.util.Set;
import org.apache.nifi.registry.MultiMap;
import org.apache.nifi.registry.VariableRegistry;

public class MultiMapVariableRegistry
implements VariableRegistry {
    protected final MultiMap<String> registry = new MultiMap();

    MultiMapVariableRegistry() {
    }

    @SafeVarargs
    MultiMapVariableRegistry(Map<String, String> ... maps) {
        this();
        if (maps != null) {
            for (Map<String, String> map : maps) {
                this.addVariables(map);
            }
        }
    }

    void addVariables(Map<String, String> map) {
        this.registry.addMap(map);
    }

    @Override
    public void addRegistry(VariableRegistry variableRegistry) {
        if (!variableRegistry.getVariables().isEmpty()) {
            this.registry.addMap(variableRegistry.getVariables());
        }
    }

    @Override
    public Map<String, String> getVariables() {
        return this.registry;
    }

    @Override
    public String getVariableValue(String variable) {
        return this.registry.get(variable);
    }

    @Override
    public Set<String> getVariableNames() {
        return this.registry.keySet();
    }
}

