/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.nifi.registry.FileVariableRegistry;

class PropertiesVariableRegistry
extends FileVariableRegistry {
    PropertiesVariableRegistry(File ... files) throws IOException {
        super(files);
    }

    PropertiesVariableRegistry(Path ... paths) throws IOException {
        super(paths);
    }

    PropertiesVariableRegistry(Properties ... properties) {
        this.addVariables(properties);
    }

    private void addVariables(Properties ... properties) {
        if (properties != null) {
            for (Properties props : properties) {
                this.addVariables(this.convertToMap(props));
            }
        }
    }

    @Override
    protected Map<String, String> convertFile(File file) throws IOException {
        try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(file));){
            Properties properties = new Properties();
            properties.load(inStream);
            Map<String, String> map = this.convertToMap(properties);
            return map;
        }
    }

    private Map<String, String> convertToMap(Properties properties) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>(properties.keySet().size());
        for (Object key : properties.keySet()) {
            propertiesMap.put((String)key, (String)properties.get(key));
        }
        return propertiesMap;
    }
}

