/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry;

import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.registry.VariableRegistryFactory;

public class VariableRegistryUtils {
    public static VariableRegistry createVariableRegistry() {
        VariableRegistry variableRegistry = VariableRegistryFactory.getInstance();
        VariableRegistry envRegistry = VariableRegistryFactory.getInstance(System.getenv());
        VariableRegistry propRegistry = VariableRegistryFactory.getPropertiesInstance(System.getProperties());
        variableRegistry.addRegistry(envRegistry);
        variableRegistry.addRegistry(propRegistry);
        return variableRegistry;
    }

    public static VariableRegistry populateRegistry(VariableRegistry variableRegistry, FlowFile flowFile, Map<String, String> additionalAttributes) {
        Map<String, String> flowFileAttributes = flowFile == null ? null : flowFile.getAttributes();
        Map<String, String> additionalMap = additionalAttributes == null ? null : additionalAttributes;
        HashMap<String, String> flowFileProps = null;
        if (flowFile != null) {
            flowFileProps = new HashMap<String, String>();
            flowFileProps.put("flowFileId", String.valueOf(flowFile.getId()));
            flowFileProps.put("fileSize", String.valueOf(flowFile.getSize()));
            flowFileProps.put("entryDate", String.valueOf(flowFile.getEntryDate()));
            flowFileProps.put("lineageStartDate", String.valueOf(flowFile.getLineageStartDate()));
        }
        VariableRegistry newRegistry = VariableRegistryFactory.getInstance();
        newRegistry.addRegistry(variableRegistry);
        if (flowFileAttributes != null) {
            newRegistry.addRegistry(VariableRegistryFactory.getInstance(flowFileAttributes));
        }
        if (additionalMap != null) {
            newRegistry.addRegistry(VariableRegistryFactory.getInstance(additionalMap));
        }
        if (flowFileProps != null) {
            newRegistry.addRegistry(VariableRegistryFactory.getInstance(flowFileProps));
        }
        return newRegistry;
    }
}

