/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;

public abstract class AbstractConfigurableComponent
implements ConfigurableComponent {
    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        return Collections.emptySet();
    }

    @Override
    public final PropertyDescriptor getPropertyDescriptor(String descriptorName) {
        PropertyDescriptor specDescriptor = new PropertyDescriptor.Builder().name(descriptorName).build();
        return this.getPropertyDescriptor(specDescriptor);
    }

    private PropertyDescriptor getPropertyDescriptor(PropertyDescriptor specDescriptor) {
        PropertyDescriptor descriptor = null;
        List<PropertyDescriptor> supportedDescriptors = this.getSupportedPropertyDescriptors();
        if (supportedDescriptors != null) {
            for (PropertyDescriptor desc : supportedDescriptors) {
                if (!specDescriptor.equals(desc)) continue;
                return desc;
            }
        }
        if ((descriptor = this.getSupportedDynamicPropertyDescriptor(specDescriptor.getName())) != null && !descriptor.isDynamic()) {
            descriptor = new PropertyDescriptor.Builder().fromPropertyDescriptor(descriptor).dynamic(true).build();
        }
        if (descriptor == null) {
            descriptor = new PropertyDescriptor.Builder().fromPropertyDescriptor(specDescriptor).addValidator(Validator.INVALID).dynamic(true).build();
        }
        return descriptor;
    }

    @Override
    public final Collection<ValidationResult> validate(ValidationContext context) {
        Collection<ValidationResult> customResults;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        List<PropertyDescriptor> supportedDescriptors = this.getSupportedPropertyDescriptors();
        if (null != supportedDescriptors) {
            for (PropertyDescriptor propertyDescriptor : supportedDescriptors) {
                ValidationResult result;
                String value = context.getProperty(propertyDescriptor).getValue();
                if (value == null) {
                    value = propertyDescriptor.getDefaultValue();
                }
                if (value == null && propertyDescriptor.isRequired()) {
                    results.add(new ValidationResult.Builder().valid(false).input(null).subject(propertyDescriptor.getName()).explanation(propertyDescriptor.getName() + " is required").build());
                    continue;
                }
                if (value == null || (result = propertyDescriptor.validate(value, context)).isValid()) continue;
                results.add(result);
            }
        }
        for (Map.Entry entry : context.getProperties().entrySet()) {
            ValidationResult result;
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            String value = (String)entry.getValue();
            if (supportedDescriptors == null || supportedDescriptors.contains(descriptor) || (result = descriptor.validate(value, context)).isValid()) continue;
            results.add(result);
        }
        if (results.isEmpty() && null != (customResults = this.customValidate(context))) {
            for (ValidationResult result : customResults) {
                if (result.isValid()) continue;
                results.add(result);
            }
        }
        return results;
    }

    @Override
    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return null;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public final List<PropertyDescriptor> getPropertyDescriptors() {
        List<PropertyDescriptor> supported = this.getSupportedPropertyDescriptors();
        return supported == null ? Collections.emptyList() : new ArrayList<PropertyDescriptor>(supported);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurableComponent)) {
            return false;
        }
        ConfigurableComponent other = (ConfigurableComponent)obj;
        return this.getIdentifier().equals(other.getIdentifier());
    }

    public int hashCode() {
        return 235 + this.getIdentifier().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getIdentifier() + "]";
    }
}

