/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.common;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.bpel.pmapi.InvalidRequestException;
import org.apache.ode.utils.ISO8601DateParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessFilter
extends Filter<FilterKeysOp>
implements Serializable {
    private static final long serialVersionUID = 9999L;
    private String nameFilter;
    private String namespaceFilter;
    private String statusFilter;
    private List<String> deployedDateFilter;
    private List<String> includes;
    private List<String> orders;

    public ProcessFilter(String string, String string2) {
        this.init(string);
        if (this.statusFilter != null) {
            try {
                StatusKeys.valueOf(this.statusFilter.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidRequestException("The status you're using in your filter isn't valid, only the activated and retired status are valid. " + illegalArgumentException.toString());
            }
        }
        if (this.deployedDateFilter != null) {
            for (String string3 : this.deployedDateFilter) {
                try {
                    ISO8601DateParser.parse((String)ProcessFilter.getDateWithoutOp(string3));
                }
                catch (ParseException parseException) {
                    throw new InvalidRequestException("Couldn't parse one of the filter date, please make sure it follows the ISO-8601 date or date/time standard (yyyyMMddhhmmss). " + parseException.toString());
                }
            }
        }
        if (string2 != null && string2.length() > 0) {
            this.orders = new ArrayList<String>(3);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string3;
                string3 = stringTokenizer.nextToken();
                try {
                    String string4 = string3;
                    if (string4.startsWith("-") || string4.startsWith("+")) {
                        string4 = string3.substring(1, string4.length());
                    }
                    OrderKeys.valueOf(string4.toUpperCase());
                    this.orders.add(string3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidRequestException("One of the ordering keys isn't valid, processes can only be sorted by name, namespace, version, status and deployed date." + illegalArgumentException.toString());
                }
            }
        }
    }

    public String getNameFilter() {
        return this.nameFilter;
    }

    public String getNamespaceFilter() {
        return this.namespaceFilter;
    }

    public String getStatusFilter() {
        return this.statusFilter;
    }

    public List<String> getDeployedDateFilter() {
        return this.deployedDateFilter;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getOrders() {
        return this.orders;
    }

    public static void main(String[] stringArray) {
        ProcessFilter processFilter = new ProcessFilter("name = dtc* status=activated deployed>=2005-11-29T15:12 deployed < 2005-11-29T15:13", "status name -version");
        System.out.println("=> " + processFilter);
    }

    @Override
    protected FilterKeysOp parseKey(String string) {
        return FilterKeysOp.valueOf(string);
    }

    protected FilterKeysOp[] getFilterKeys() {
        return FilterKeysOp.values();
    }

    @Override
    protected void process(FilterKeysOp filterKeysOp, Filter.Restriction<String> restriction) {
        filterKeysOp.process(this, restriction.op, (String)restriction.value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum StatusKeys {
        ACTIVATED,
        RETIRED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OrderKeys {
        NAME,
        NAMESPACE,
        VERSION,
        STATUS,
        DEPLOYED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FilterKeysOp {
        NAME{

            void process(ProcessFilter processFilter, String string, String string2) {
                processFilter.nameFilter = string2;
            }
        }
        ,
        NAMESPACE{

            void process(ProcessFilter processFilter, String string, String string2) {
                processFilter.namespaceFilter = string2;
            }
        }
        ,
        STATUS{

            void process(ProcessFilter processFilter, String string, String string2) {
                processFilter.statusFilter = string2;
            }
        }
        ,
        DEPLOYED{

            void process(ProcessFilter processFilter, String string, String string2) {
                if (processFilter.deployedDateFilter == null) {
                    processFilter.deployedDateFilter = new ArrayList();
                }
                processFilter.deployedDateFilter.add(string + string2);
            }
        };


        abstract void process(ProcessFilter var1, String var2, String var3);
    }
}

