/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.pmapi;

import java.util.HashSet;
import java.util.StringTokenizer;

public class ProcessInfoCustomizer {
    public static final ProcessInfoCustomizer ALL = new ProcessInfoCustomizer(Item.ENDPOINTS, Item.PROPERTIES, Item.SUMMARY);
    public static final ProcessInfoCustomizer NONE = new ProcessInfoCustomizer(new Item[0]);
    private HashSet<Item> _includes = new HashSet();

    public ProcessInfoCustomizer(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            Item item = Item.valueOf(string2);
            this._includes.add(item);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Item item : this._includes) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(item.toString());
        }
        return stringBuilder.toString();
    }

    public ProcessInfoCustomizer(Item ... itemArray) {
        for (Item item : itemArray) {
            this._includes.add(item);
        }
    }

    public boolean includeInstanceSummary() {
        return this._includes.contains((Object)Item.SUMMARY);
    }

    public boolean includeProcessProperties() {
        return this._includes.contains((Object)Item.PROPERTIES);
    }

    public boolean includeEndpoints() {
        return this._includes.contains((Object)Item.ENDPOINTS);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Item {
        SUMMARY,
        PROPERTIES,
        ENDPOINTS;

    }
}

