/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.epr;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSAEndpoint
implements MutableEndpoint {
    private static final Log __log = LogFactory.getLog(WSAEndpoint.class);
    private Element _eprElmt;

    public WSAEndpoint() {
    }

    public WSAEndpoint(Map map) {
        this();
        this.fromMap(map);
    }

    public String getSessionId() {
        NodeList nodeList = this._eprElmt.getElementsByTagNameNS("http://www.intalio.com/type/session", "session");
        if (nodeList.getLength() > 0) {
            return nodeList.item(0).getTextContent();
        }
        return null;
    }

    public void setSessionId(String string) {
        NodeList nodeList = this._eprElmt.getElementsByTagNameNS("http://www.intalio.com/type/session", "session");
        if (nodeList.getLength() > 0) {
            nodeList.item(0).setTextContent(string);
        } else {
            Element element = this._eprElmt.getOwnerDocument().createElementNS("http://www.intalio.com/type/session", "session");
            element.setTextContent(string);
            this._eprElmt.appendChild(element);
        }
    }

    public String getUrl() {
        return this._eprElmt.getElementsByTagNameNS("http://www.w3.org/2005/08/addressing", "Address").item(0).getTextContent();
    }

    public void setUrl(String string) {
        NodeList nodeList = this._eprElmt.getElementsByTagNameNS("http://www.w3.org/2005/08/addressing", "Address");
        if (nodeList.getLength() > 0) {
            nodeList.item(0).setTextContent(string);
        } else {
            Element element = this._eprElmt.getOwnerDocument().createElementNS("http://www.w3.org/2005/08/addressing", "Address");
            element.setTextContent(string);
            this._eprElmt.appendChild(element);
        }
    }

    public QName getServiceName() {
        NodeList nodeList = this._eprElmt.getElementsByTagNameNS("http://www.w3.org/2005/08/addressing", "Metadata");
        if (nodeList.getLength() > 0) {
            Element element = (Element)nodeList.item(0);
            Element element2 = DOMUtils.getFirstChildElement((Element)element);
            String string = element2.getTextContent();
            int n = string.indexOf(":");
            String string2 = string.substring(0, n);
            String string3 = this._eprElmt.getOwnerDocument().lookupNamespaceURI(string2);
            if (string3 == null) {
                string3 = element2.getAttribute("xmlns:" + string2);
            }
            if (string3 == null) {
                __log.warn((Object)"Couldn't find an appropriate namespace for service!");
            }
            QName qName = new QName(string3, string.substring(n + 1, string.length()));
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Got service name from WSAEndpoint: " + qName));
            }
            return qName;
        }
        return null;
    }

    public String getPortName() {
        NodeList nodeList = this._eprElmt.getElementsByTagNameNS("http://www.w3.org/2005/08/addressing", "Metadata");
        if (nodeList.getLength() > 0) {
            Element element = (Element)nodeList.item(0);
            Element element2 = DOMUtils.getFirstChildElement((Element)element);
            return element2.getAttribute("EndpointName");
        }
        return null;
    }

    public boolean accept(Node node) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            if (element.getLocalName().equals(SERVICE_REF_QNAME.getLocalPart()) && element.getNamespaceURI().equals(SERVICE_REF_QNAME.getNamespaceURI())) {
                element = DOMUtils.getFirstChildElement((Element)element);
            }
            if (element != null && element.getLocalName().equals("EndpointReference") && element.getNamespaceURI().equals("http://www.w3.org/2005/08/addressing")) {
                return true;
            }
        }
        return false;
    }

    public void set(Node node) {
        this._eprElmt = node.getNamespaceURI().equals(SERVICE_REF_QNAME.getNamespaceURI()) ? DOMUtils.getFirstChildElement((Element)((Element)node)) : (Element)node;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Setting a WSAEndpoint value: " + DOMUtils.domToString((Node)this._eprElmt)));
        }
    }

    public Document toXML() {
        Document document = DOMUtils.newDocument();
        Element element = document.createElementNS(SERVICE_REF_QNAME.getNamespaceURI(), SERVICE_REF_QNAME.getLocalPart());
        document.appendChild(element);
        element.appendChild(document.importNode(this._eprElmt, true));
        return this._eprElmt.getOwnerDocument();
    }

    public Map toMap() {
        NodeList nodeList;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("address", this.getUrl());
        String string = this.getSessionId();
        if (string != null) {
            hashMap.put("session", string);
        }
        if ((nodeList = this._eprElmt.getElementsByTagNameNS("http://www.w3.org/2005/08/addressing", "Metadata")).getLength() > 0) {
            Element element = (Element)nodeList.item(0);
            Element element2 = DOMUtils.getFirstChildElement((Element)element);
            String string2 = element2.getTextContent();
            int n = string2.indexOf(":");
            String string3 = string2.substring(0, n);
            String string4 = null;
            try {
                string4 = this._eprElmt.getOwnerDocument().lookupNamespaceURI(string3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (string4 == null) {
                string4 = element2.getAttribute("xmlns:" + string3);
            }
            hashMap.put("service", new QName(string4, string2.substring(n + 1, string2.length())));
            hashMap.put("port", element2.getAttribute("EndpointName"));
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Filled transfo map with service: " + hashMap.get("service")));
                __log.debug((Object)("Filled transfo map with port: " + hashMap.get("port")));
            }
        }
        return hashMap;
    }

    public void fromMap(Map map) {
        Element element;
        Document document = DOMUtils.newDocument();
        Element element2 = document.createElementNS(SERVICE_REF_QNAME.getNamespaceURI(), SERVICE_REF_QNAME.getLocalPart());
        document.appendChild(element2);
        this._eprElmt = document.createElementNS("http://www.w3.org/2005/08/addressing", "EndpointReference");
        element2.appendChild(this._eprElmt);
        Element element3 = document.createElementNS("http://www.w3.org/2005/08/addressing", "Address");
        element3.setTextContent((String)map.get("address"));
        if (map.get("session") != null) {
            element = document.createElementNS("http://www.intalio.com/type/session", "session");
            element.setTextContent((String)map.get("session"));
            this._eprElmt.appendChild(element);
        }
        if (map.get("service") != null) {
            element = document.createElementNS("http://www.w3.org/2005/08/addressing", "Metadata");
            this._eprElmt.appendChild(element);
            Element element4 = document.createElementNS("http://www.w3.org/2006/05/addressing/wsdl", "ServiceName");
            element.appendChild(element4);
            QName qName = (QName)map.get("service");
            element4.setAttribute("xmlns:servicens", qName.getNamespaceURI());
            element4.setTextContent("servicens:" + qName.getLocalPart());
            element4.setAttribute("EndpointName", (String)map.get("port"));
        }
        this._eprElmt.appendChild(element3);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Constructed a new WSAEndpoint: " + DOMUtils.domToString((Node)this._eprElmt)));
        }
    }
}

