/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.epr;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDL11Endpoint
implements MutableEndpoint {
    private Element _serviceElmt;

    public String getUrl() {
        Element element = (Element)this._serviceElmt.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "port").item(0);
        Element element2 = (Element)element.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/soap/", "address").item(0);
        if (element2 == null) {
            element2 = (Element)element.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/http/", "address").item(0);
        }
        if (element2 == null) {
            throw new IllegalArgumentException("soap:address and http:address element in element " + DOMUtils.domToString((Node)this._serviceElmt) + " is missing or in the wrong namespace.");
        }
        return element2.getAttribute("location");
    }

    public QName getServiceName() {
        return new QName(this._serviceElmt.getAttribute("targetNamespace"), this._serviceElmt.getAttribute("name"));
    }

    public boolean accept(Node node) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            if (element.getLocalName().equals("service-ref") && (element.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/03/business-process/") || element.getNamespaceURI().equals("http://docs.oasis-open.org/wsbpel/2.0/serviceref"))) {
                element = DOMUtils.getFirstChildElement((Element)element);
            }
            if (element.getLocalName().equals("service") && element.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/")) {
                return true;
            }
        }
        return false;
    }

    public void set(Node node) {
        this._serviceElmt = node.getNamespaceURI().equals(SERVICE_REF_QNAME.getNamespaceURI()) ? DOMUtils.getFirstChildElement((Element)((Element)node)) : (Element)node;
    }

    public Document toXML() {
        Document document = DOMUtils.newDocument();
        Element element = document.createElementNS("http://docs.oasis-open.org/wsbpel/2.0/serviceref", "service-ref");
        document.appendChild(element);
        element.appendChild(document.importNode(this._serviceElmt, true));
        return this._serviceElmt.getOwnerDocument();
    }

    public Map toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
        hashMap.put("address", this.getUrl());
        hashMap.put("service", new QName(this._serviceElmt.getAttribute("targetNamespace"), this._serviceElmt.getAttribute("name")));
        Element element = DOMUtils.getFirstChildElement((Element)this._serviceElmt);
        hashMap.put("port", element.getAttribute("name"));
        return hashMap;
    }

    public void fromMap(Map map) {
        Object object;
        Document document = DOMUtils.newDocument();
        Element element = document.createElementNS(SERVICE_REF_QNAME.getNamespaceURI(), SERVICE_REF_QNAME.getLocalPart());
        document.appendChild(element);
        this._serviceElmt = document.createElementNS("http://schemas.xmlsoap.org/wsdl/", "service");
        element.appendChild(this._serviceElmt);
        if (map.get("service") != null) {
            object = (QName)map.get("service");
            this._serviceElmt.setAttribute("name", ((QName)object).getLocalPart());
            this._serviceElmt.setAttribute("targetNamespace", ((QName)object).getNamespaceURI());
        }
        object = document.createElementNS("http://schemas.xmlsoap.org/wsdl/", "port");
        if (map.get("port") != null) {
            object.setAttribute("name", (String)map.get("port"));
        }
        object.setAttribute("binding", "");
        Element element2 = document.createElementNS("http://schemas.xmlsoap.org/wsdl/soap/", "address");
        if (map.get("address") != null) {
            element2.setAttribute("location", (String)map.get("address"));
        }
        this._serviceElmt.appendChild((Node)object);
        object.appendChild(element2);
    }
}

