/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.il.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.SystemUtils;

public class OdeConfigProperties {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(OdeConfigProperties.class);
    public static final String PROP_DB_MODE = "db.mode";
    public static final String PROP_DB_EXTERNAL_DS = "db.ext.dataSource";
    public static final String PROP_DB_EMBEDDED_NAME = "db.emb.name";
    public static final String PROP_DB_INTERNAL_URL = "db.int.jdbcurl";
    public static final String PROP_DB_INTERNAL_DRIVER = "db.int.driver";
    public static final String PROP_DB_INTERNAL_PASSWORD = "db.int.password";
    public static final String PROP_DB_INTERNAL_USER = "db.int.username";
    public static final String PROP_DB_LOGGING = "db.logging";
    public static final String PROP_TX_FACTORY_CLASS = "tx.factory.class";
    public static final String PROP_POOL_MAX = "db.pool.max";
    public static final String PROP_POOL_MIN = "db.pool.min";
    public static final String PROP_DB_POOL_BLOCKING = "db.pool.blocking";
    public static final String PROP_THREAD_POOL_SIZE = "threads.pool.size";
    public static final String PROP_CONNECTOR_PORT = "jca.port";
    public static final String PROP_CONNECTOR_NAME = "jca.name";
    public static final String PROP_WORKING_DIR = "working.dir";
    public static final String PROP_EVENT_LISTENERS = "event.listeners";
    public static final String PROP_MEX_INTERCEPTORS = "mex.interceptors";
    public static final String PROP_MEX_INMEM_TTL = "mex.inmem.ttl";
    public static final String PROP_PROCESS_DEHYDRATION = "process.dehydration";
    public static final String PROP_DAOCF = "dao.factory";
    private File _cfgFile;
    private String _prefix;
    private Properties _props;
    private static String __dbEmbName = "jpadb";
    private static String __daoCfClass = "org.apache.ode.dao.jpa.BPELDAOConnectionFactoryImpl";

    public OdeConfigProperties(File file, String string) {
        this._cfgFile = file;
        this._prefix = string;
        this._props = new Properties();
    }

    public OdeConfigProperties(Properties properties, String string) {
        this._cfgFile = null;
        this._prefix = string;
        this._props = properties;
    }

    public File getFile() {
        return this._cfgFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        if (this._cfgFile.exists()) {
            __log.debug((Object)("config file exists: " + this._cfgFile));
            Object object = null;
            try {
                object = new FileInputStream(this._cfgFile);
                this._props.load((InputStream)object);
            }
            finally {
                if (object != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        __log.debug((Object)("config file does not exists: " + this._cfgFile));
        throw new FileNotFoundException("" + this._cfgFile);
        for (Object e : this._props.keySet()) {
            String string = (String)this._props.get(e);
            string = SystemUtils.replaceSystemProperties((String)string);
            this._props.put(e, string);
        }
    }

    public String getDbEmbeddedName() {
        return this.getProperty(PROP_DB_EMBEDDED_NAME, __dbEmbName);
    }

    public DatabaseMode getDbMode() {
        return DatabaseMode.valueOf(this.getProperty(PROP_DB_MODE, DatabaseMode.EMBEDDED.toString()).trim().toUpperCase());
    }

    public String getDAOConnectionFactory() {
        return this.getProperty(PROP_DAOCF, __daoCfClass);
    }

    public String getDbDataSource() {
        return this.getProperty(PROP_DB_EXTERNAL_DS, "java:comp/env/jdbc/ode-ds");
    }

    public String getDbIntenralJdbcUrl() {
        return this.getProperty(PROP_DB_INTERNAL_URL, "jdbc:derby://localhost/ode");
    }

    public String getDbInternalJdbcDriverClass() {
        return this.getProperty(PROP_DB_INTERNAL_DRIVER, "org.apache.derby.jdbc.ClientDriver");
    }

    public boolean getPoolBlocking() {
        return Boolean.valueOf(this.getProperty(PROP_DB_POOL_BLOCKING, "false"));
    }

    public int getThreadPoolMaxSize() {
        return Integer.valueOf(this.getProperty(PROP_THREAD_POOL_SIZE, "0"));
    }

    public int getPoolMaxSize() {
        return Integer.valueOf(this.getProperty(PROP_POOL_MAX, "10"));
    }

    public int getPoolMinSize() {
        return Integer.valueOf(this.getProperty(PROP_POOL_MIN, "1"));
    }

    public int getConnectorPort() {
        return Integer.valueOf(this.getProperty(PROP_CONNECTOR_PORT, "2099"));
    }

    public String getConnectorName() {
        return this.getProperty(PROP_CONNECTOR_NAME, "ode");
    }

    public String getWorkingDir() {
        return this.getProperty(PROP_WORKING_DIR);
    }

    public String getTxFactoryClass() {
        return this.getProperty(PROP_TX_FACTORY_CLASS, "org.apache.ode.il.EmbeddedGeronimoFactory");
    }

    public String getEventListeners() {
        return this.getProperty(PROP_EVENT_LISTENERS);
    }

    public String getMessageExchangeInterceptors() {
        return this.getProperty(PROP_MEX_INTERCEPTORS);
    }

    public long getInMemMexTtl() {
        return Long.valueOf(this.getProperty(PROP_MEX_INMEM_TTL, "600000"));
    }

    public boolean isDehydrationEnabled() {
        return Boolean.valueOf(this.getProperty(PROP_PROCESS_DEHYDRATION, "false"));
    }

    public boolean isDbLoggingEnabled() {
        return Boolean.valueOf(this.getProperty(PROP_DB_LOGGING, "false"));
    }

    protected String getProperty(String string) {
        return this._props.getProperty(this._prefix + string);
    }

    protected String getProperty(String string, String string2) {
        return this._props.getProperty(this._prefix + string, string2);
    }

    public Properties getProperties() {
        return this._props;
    }

    public String getDbInternalUserName() {
        return this.getProperty(PROP_DB_INTERNAL_USER);
    }

    public String getDbInternalPassword() {
        return this.getProperty(PROP_DB_INTERNAL_PASSWORD);
    }

    static {
        String string = System.getProperty("ode.persistence");
        if (string != null && "hibernate".equalsIgnoreCase(string)) {
            __log.debug((Object)"Using HIBERNATE due to system property override!");
            __dbEmbName = "hibdb";
            __daoCfClass = "org.apache.ode.daohib.bpel.BpelDAOConnectionFactoryImpl";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DatabaseMode {
        EXTERNAL,
        INTERNAL,
        EMBEDDED;

    }
}

