/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jacob.ap;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.util.DeclarationFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;

class ChannelTypeAnnotationProcessor
implements AnnotationProcessor {
    AnnotationProcessorEnvironment _env;
    AnnotationTypeDeclaration _atd;

    ChannelTypeAnnotationProcessor(AnnotationTypeDeclaration annotationTypeDeclaration, AnnotationProcessorEnvironment annotationProcessorEnvironment) {
        this._atd = annotationTypeDeclaration;
        this._env = annotationProcessorEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        Collection collection = DeclarationFilter.getFilter(InterfaceDeclaration.class).filter(this._env.getDeclarationsAnnotatedWith(this._atd), InterfaceDeclaration.class);
        for (InterfaceDeclaration interfaceDeclaration : collection) {
            PrintWriter printWriter = null;
            try {
                printWriter = this._env.getFiler().createSourceFile(interfaceDeclaration.getQualifiedName() + "Channel");
                this.writeChannelClass(printWriter, interfaceDeclaration);
            }
            catch (IOException iOException) {
                this._env.getMessager().printError(interfaceDeclaration.getPosition(), "IO Error: " + iOException.getMessage());
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
            }
            try {
                printWriter = this._env.getFiler().createSourceFile(interfaceDeclaration.getQualifiedName() + "ChannelListener");
                this.writeChannelListenerClass(printWriter, interfaceDeclaration);
            }
            catch (IOException iOException) {
                this._env.getMessager().printError(interfaceDeclaration.getPosition(), "IO Error: " + iOException.getMessage());
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
            }
        }
    }

    private void writeChannelClass(PrintWriter printWriter, InterfaceDeclaration interfaceDeclaration) {
        printWriter.println("/*");
        printWriter.println(" * SOURCE FILE GENERATATED BY JACOB CHANNEL CLASS GENERATOR");
        printWriter.println(" * ");
        printWriter.println(" *               !!! DO NOT EDIT !!!! ");
        printWriter.println(" * ");
        printWriter.println(" * Generated On  : " + new Date());
        printWriter.println(" * For Interface : " + interfaceDeclaration.getQualifiedName());
        printWriter.println(" */");
        printWriter.println();
        printWriter.println("package " + interfaceDeclaration.getPackage().getQualifiedName() + ";");
        printWriter.println();
        printWriter.println("/**");
        printWriter.println(" * An auto-generated channel interface for the channel type");
        printWriter.println(" * {@link " + interfaceDeclaration.getQualifiedName() + "}.");
        printWriter.println(" * @see " + interfaceDeclaration.getQualifiedName());
        printWriter.println(" * @see " + interfaceDeclaration.getQualifiedName() + "ChannelListener");
        printWriter.println(" */");
        printWriter.println("public interface " + interfaceDeclaration.getSimpleName() + "Channel");
        Collection collection = interfaceDeclaration.getSuperinterfaces();
        if (collection.isEmpty()) {
            printWriter.println("    extends org.apache.ode.jacob.Channel, ");
        } else {
            printWriter.print("    extends ");
            for (InterfaceType interfaceType : collection) {
                printWriter.println("            " + interfaceType.getDeclaration().getQualifiedName() + "Channel, ");
            }
            printWriter.println("            org.apache.ode.jacob.Channel, ");
        }
        printWriter.println("            " + interfaceDeclaration.getQualifiedName());
        printWriter.println("{}");
        printWriter.flush();
    }

    private void writeChannelListenerClass(PrintWriter printWriter, InterfaceDeclaration interfaceDeclaration) {
        printWriter.println("/*");
        printWriter.println(" * SOURCE FILE GENERATATED BY JACOB CHANNEL CLASS GENERATOR");
        printWriter.println(" * ");
        printWriter.println(" *               !!! DO NOT EDIT !!!! ");
        printWriter.println(" * ");
        printWriter.println(" * Generated On  : " + new Date());
        printWriter.println(" * For Interface : " + interfaceDeclaration.getQualifiedName());
        printWriter.println(" */");
        printWriter.println();
        printWriter.println("package " + interfaceDeclaration.getPackage().getQualifiedName() + ";");
        printWriter.println();
        printWriter.println("import org.apache.commons.logging.LogFactory;");
        printWriter.println("import org.apache.commons.logging.Log;");
        printWriter.println();
        printWriter.println("/**");
        printWriter.println(" * An auto-generated channel listener abstract class for the ");
        printWriter.println(" * {@link " + interfaceDeclaration.getQualifiedName() + "} channel type. ");
        printWriter.println(" * @see " + interfaceDeclaration.getQualifiedName());
        printWriter.println(" * @see " + interfaceDeclaration.getQualifiedName() + "Channel");
        printWriter.println(" */");
        printWriter.println("public abstract class " + interfaceDeclaration.getSimpleName() + "ChannelListener");
        printWriter.println("    extends org.apache.ode.jacob.ChannelListener<" + interfaceDeclaration.getQualifiedName() + "Channel>");
        printWriter.println("    implements " + interfaceDeclaration.getQualifiedName());
        printWriter.println("{");
        printWriter.println();
        printWriter.println("    private static final Log __log = LogFactory.getLog(" + interfaceDeclaration.getQualifiedName() + ".class);");
        printWriter.println();
        printWriter.println("    protected Log log() { return __log; } ");
        printWriter.println();
        printWriter.println("    protected " + interfaceDeclaration.getSimpleName() + "ChannelListener(" + interfaceDeclaration.getQualifiedName() + "Channel channel) {");
        printWriter.println("       super(channel);");
        printWriter.println("    }");
        printWriter.println("}");
        printWriter.flush();
    }
}

