/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheControl {
    private int maxAge = -1;
    private int sMaxAge = -1;
    private boolean isPrivate = false;
    private boolean noCache = false;
    private boolean noStore = false;
    private boolean noTransform = true;
    private boolean mustRevalidate = false;
    private boolean proxyRevalidate = false;
    private Map<String, String> cacheExtensions = null;
    private List<String> noCacheFields = null;
    private List<String> privateFields = null;
    private static final RuntimeDelegate.HeaderDelegate<CacheControl> headerDelegate = RuntimeDelegate.getInstance().createHeaderDelegate(CacheControl.class);

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CacheControl)) {
            return false;
        }
        CacheControl other = (CacheControl)obj;
        if (this.isPrivate != other.isPrivate()) {
            return false;
        }
        if (this.noCache != other.isNoCache()) {
            return false;
        }
        if (this.noStore != other.isNoStore()) {
            return false;
        }
        if (this.noTransform != other.isNoTransform()) {
            return false;
        }
        if (this.mustRevalidate != other.isMustRevalidate()) {
            return false;
        }
        if (this.proxyRevalidate != other.isProxyRevalidate()) {
            return false;
        }
        if (this.maxAge != other.getMaxAge()) {
            return false;
        }
        if (this.sMaxAge != other.getSMaxAge()) {
            return false;
        }
        if (!((Object)this.getCacheExtension()).equals(other.getCacheExtension())) {
            return false;
        }
        if (!((Object)this.getPrivateFields()).equals(other.getPrivateFields())) {
            return false;
        }
        return ((Object)this.getNoCacheFields()).equals(other.getNoCacheFields());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.maxAge;
        result = 31 * result + this.sMaxAge;
        result = 31 * result + (this.isPrivate ? 1 : 0);
        result = 31 * result + (this.noCache ? 1 : 0);
        result = 31 * result + (this.noStore ? 1 : 0);
        result = 31 * result + (this.noTransform ? 1 : 0);
        result = 31 * result + (this.mustRevalidate ? 1 : 0);
        result = 31 * result + (this.proxyRevalidate ? 1 : 0);
        result = 31 * result + ((Object)this.getCacheExtension()).hashCode();
        result = 31 * result + ((Object)this.getNoCacheFields()).hashCode();
        result = 31 * result + ((Object)this.getPrivateFields()).hashCode();
        return result;
    }

    public Map<String, String> getCacheExtension() {
        if (this.cacheExtensions == null) {
            this.cacheExtensions = new HashMap<String, String>();
        }
        return this.cacheExtensions;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public List<String> getNoCacheFields() {
        if (this.noCacheFields == null) {
            this.noCacheFields = new ArrayList<String>();
        }
        return this.noCacheFields;
    }

    public List<String> getPrivateFields() {
        if (this.privateFields == null) {
            this.privateFields = new ArrayList<String>();
        }
        return this.privateFields;
    }

    public int getSMaxAge() {
        return this.sMaxAge;
    }

    public boolean isMustRevalidate() {
        return this.mustRevalidate;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public boolean isNoStore() {
        return this.noStore;
    }

    public boolean isNoTransform() {
        return this.noTransform;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isProxyRevalidate() {
        return this.proxyRevalidate;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public void setMustRevalidate(boolean mustRevalidate) {
        this.mustRevalidate = mustRevalidate;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    public void setNoStore(boolean noStore) {
        this.noStore = noStore;
    }

    public void setNoTransform(boolean noTransform) {
        this.noTransform = noTransform;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public void setProxyRevalidate(boolean proxyRevalidate) {
        this.proxyRevalidate = proxyRevalidate;
    }

    public void setSMaxAge(int sMaxAge) {
        this.sMaxAge = sMaxAge;
    }

    public String toString() {
        return headerDelegate.toString(this);
    }

    public static CacheControl valueOf(String value) {
        return headerDelegate.fromString(value);
    }
}

