/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericEntity<T> {
    private final T entity;
    private final Type genericType;

    protected GenericEntity(T entity) {
        if (entity == null) {
            throw new IllegalArgumentException();
        }
        this.entity = entity;
        Type superclass = this.getClass().getGenericSuperclass();
        this.genericType = ((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    public GenericEntity(T entity, Type genericType) {
        if (entity == null) {
            throw new IllegalArgumentException();
        }
        if (genericType == null) {
            throw new IllegalArgumentException();
        }
        this.checkCompatibility(entity.getClass(), genericType);
        this.entity = entity;
        this.genericType = genericType;
    }

    private void checkCompatibility(Class<?> rawType, Type genericType) {
        if (genericType instanceof Class) {
            if (!((Class)genericType).isAssignableFrom(rawType)) {
                throw new IllegalArgumentException();
            }
        } else if (genericType instanceof ParameterizedType) {
            this.checkCompatibility(rawType, ((ParameterizedType)genericType).getRawType());
        } else if (genericType instanceof GenericArrayType) {
            if (!rawType.isArray()) {
                throw new IllegalArgumentException();
            }
            this.checkCompatibility(rawType.getComponentType(), ((GenericArrayType)genericType).getGenericComponentType());
        }
    }

    public final T getEntity() {
        return this.entity;
    }

    public final Class<?> getRawType() {
        return this.entity.getClass();
    }

    public final Type getType() {
        return this.genericType;
    }
}

