/*
 * Decompiled with CFR 0.152.
 */
package javax.validation;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javax.validation.Configuration;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.bootstrap.GenericBootstrap;
import javax.validation.bootstrap.ProviderSpecificBootstrap;
import javax.validation.spi.BootstrapState;
import javax.validation.spi.ValidationProvider;
import org.apache.geronimo.osgi.locator.ProviderLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validation {
    public static ValidatorFactory buildDefaultValidatorFactory() {
        return Validation.byDefaultProvider().configure().buildValidatorFactory();
    }

    public static GenericBootstrap byDefaultProvider() {
        return new GenericBootstrapImpl();
    }

    public static <T extends Configuration<T>, U extends ValidationProvider<T>> ProviderSpecificBootstrap<T> byProvider(Class<U> providerType) {
        return new ProviderSpecificBootstrapImpl(providerType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultValidationProviderResolver
    implements ValidationProviderResolver {
        private volatile WeakHashMap<ClassLoader, List<ValidationProvider<?>>> providerCache = new WeakHashMap();

        private DefaultValidationProviderResolver() {
        }

        @Override
        public List<ValidationProvider<?>> getValidationProviders() {
            List<ValidationProvider<?>> providers;
            ClassLoader cl = PrivClassLoader.get(null);
            if (cl == null) {
                cl = PrivClassLoader.get(DefaultValidationProviderResolver.class);
            }
            if ((providers = this.providerCache.get(cl)) == null) {
                providers = new ArrayList();
                try {
                    List serviceProviders = ProviderLocator.getServices((String)ValidationProvider.class.getName(), this.getClass(), (ClassLoader)cl);
                    for (Object provider : serviceProviders) {
                        providers.add((ValidationProvider)provider);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new ValidationException("Failed to load provider", e);
                }
                catch (InstantiationException e) {
                    throw new ValidationException("Failed to instantiate provider", e);
                }
                catch (IllegalAccessException e) {
                    throw new ValidationException("Failed to access provider", e);
                }
                catch (ClassCastException e) {
                    throw new ValidationException("Invalid provider definition", e);
                }
                catch (Exception e) {
                    throw new ValidationException("Failed to instantiate provider", e);
                }
                this.providerCache.put(cl, providers);
            }
            return providers;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class PrivClassLoader
        implements PrivilegedAction<ClassLoader> {
            private final Class<?> c;

            public static ClassLoader get(Class<?> c) {
                PrivClassLoader action = new PrivClassLoader(c);
                if (System.getSecurityManager() != null) {
                    return AccessController.doPrivileged(action);
                }
                return action.run();
            }

            private PrivClassLoader(Class<?> c) {
                this.c = c;
            }

            @Override
            public ClassLoader run() {
                if (this.c != null) {
                    return this.c.getClassLoader();
                }
                return Thread.currentThread().getContextClassLoader();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GenericBootstrapImpl
    implements GenericBootstrap,
    BootstrapState {
        private ValidationProviderResolver vpDefaultResolver;
        private ValidationProviderResolver vpResolver;

        private GenericBootstrapImpl() {
        }

        @Override
        public GenericBootstrap providerResolver(ValidationProviderResolver resolver) {
            this.vpResolver = resolver;
            return this;
        }

        @Override
        public ValidationProviderResolver getValidationProviderResolver() {
            return this.vpResolver;
        }

        @Override
        public ValidationProviderResolver getDefaultValidationProviderResolver() {
            if (this.vpDefaultResolver == null) {
                this.vpDefaultResolver = new DefaultValidationProviderResolver();
            }
            return this.vpDefaultResolver;
        }

        @Override
        public Configuration<?> configure() {
            ValidationProviderResolver resolv = this.vpResolver;
            try {
                if (resolv == null) {
                    resolv = this.getDefaultValidationProviderResolver();
                }
                return resolv.getValidationProviders().get(0).createGenericConfiguration(this);
            }
            catch (Exception e) {
                throw new ValidationException("Could not create Configuration.", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProviderSpecificBootstrapImpl<T extends Configuration<T>, U extends ValidationProvider<T>>
    implements ProviderSpecificBootstrap<T> {
        private final Class<U> providerClass;
        private ValidationProviderResolver vpResolver;

        public ProviderSpecificBootstrapImpl(Class<U> validationProviderClass) {
            this.providerClass = validationProviderClass;
        }

        @Override
        public ProviderSpecificBootstrap<T> providerResolver(ValidationProviderResolver resolver) {
            this.vpResolver = resolver;
            return this;
        }

        @Override
        public T configure() {
            if (this.providerClass == null) {
                throw new ValidationException("No resolver provided");
            }
            GenericBootstrapImpl impl = new GenericBootstrapImpl();
            if (this.vpResolver == null) {
                this.vpResolver = impl.getDefaultValidationProviderResolver();
            } else {
                impl.providerResolver(this.vpResolver);
            }
            for (ValidationProvider<?> vProvider : this.vpResolver.getValidationProviders()) {
                if (!this.providerClass.isAssignableFrom(vProvider.getClass())) continue;
                return ((ValidationProvider)this.providerClass.cast(vProvider)).createSpecializedConfiguration(impl);
            }
            throw new ValidationException("No provider found for " + this.providerClass);
        }
    }
}

