/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.axis;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.Context;
import javax.wsdl.Port;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import org.apache.axis.Handler;
import org.apache.axis.description.JavaServiceDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.HandlerInfoChainFactory;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.openejb.BeanContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.core.webservices.HandlerChainData;
import org.apache.openejb.core.webservices.HandlerData;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.jee.JavaWsdlMapping;
import org.apache.openejb.jee.PortComponent;
import org.apache.openejb.server.axis.AxisWsContainer;
import org.apache.openejb.server.axis.EjbRpcProvider;
import org.apache.openejb.server.axis.JavaServiceDescBuilder;
import org.apache.openejb.server.axis.PojoProvider;
import org.apache.openejb.server.axis.assembler.CommonsSchemaInfoBuilder;
import org.apache.openejb.server.axis.assembler.JaxRpcServiceInfo;
import org.apache.openejb.server.axis.assembler.JaxRpcServiceInfoBuilder;
import org.apache.openejb.server.axis.assembler.XmlSchemaInfo;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.webservices.WsService;

public class AxisService
extends WsService {
    private final Map<String, AxisWsContainer> wsContainers = new TreeMap<String, AxisWsContainer>();

    public String getName() {
        return "axis";
    }

    private JaxRpcServiceInfo getJaxRpcServiceInfo(ClassLoader classLoader) throws OpenEJBException {
        JavaWsdlMapping mapping = null;
        CommonsSchemaInfoBuilder xmlBeansSchemaInfoBuilder = new CommonsSchemaInfoBuilder(null, null);
        PortComponent portComponent = null;
        Port port = null;
        String wsdlFile = null;
        XmlSchemaInfo schemaInfo = xmlBeansSchemaInfoBuilder.createSchemaInfo();
        JaxRpcServiceInfoBuilder serviceInfoBuilder = new JaxRpcServiceInfoBuilder(mapping, schemaInfo, portComponent, port, wsdlFile, classLoader);
        JaxRpcServiceInfo serviceInfo = serviceInfoBuilder.createServiceInfo();
        return serviceInfo;
    }

    protected HttpListener createEjbWsContainer(URL moduleBaseUrl, PortData port, BeanContext beanContext) throws Exception {
        ClassLoader classLoader = beanContext.getClassLoader();
        JaxRpcServiceInfo serviceInfo = this.getJaxRpcServiceInfo(classLoader);
        JavaServiceDescBuilder javaServiceDescBuilder = new JavaServiceDescBuilder(serviceInfo, classLoader);
        JavaServiceDesc serviceDesc = javaServiceDescBuilder.createServiceDesc();
        EjbRpcProvider provider = new EjbRpcProvider(beanContext, this.createHandlerInfos(port.getHandlerChains()));
        SOAPService service = new SOAPService(null, (Handler)provider, null);
        service.setServiceDescription((ServiceDesc)serviceDesc);
        service.setOption("className", (Object)beanContext.getServiceEndpointInterface().getName());
        serviceDesc.setImplClass(beanContext.getServiceEndpointInterface());
        AxisWsContainer container = new AxisWsContainer(port.getWsdlUrl(), service, null, classLoader);
        this.wsContainers.put(beanContext.getDeploymentID().toString(), container);
        return container;
    }

    protected void destroyEjbWsContainer(String deploymentId) {
        AxisWsContainer container = this.wsContainers.remove(deploymentId);
        if (container != null) {
            container.destroy();
        }
    }

    protected HttpListener createPojoWsContainer(URL moduleBaseUrl, PortData port, String serviceId, Class target, Context context, String contextRoot) throws Exception {
        ClassLoader classLoader = target.getClassLoader();
        JaxRpcServiceInfo serviceInfo = this.getJaxRpcServiceInfo(classLoader);
        JavaServiceDescBuilder javaServiceDescBuilder = new JavaServiceDescBuilder(serviceInfo, classLoader);
        JavaServiceDesc serviceDesc = javaServiceDescBuilder.createServiceDesc();
        PojoProvider provider = new PojoProvider();
        SOAPService service = new SOAPService(null, (Handler)provider, null);
        service.setServiceDescription((ServiceDesc)serviceDesc);
        service.setOption("className", (Object)target.getName());
        List<HandlerInfo> handlerInfos = this.createHandlerInfos(port.getHandlerChains());
        HandlerInfoChainFactory handlerInfoChainFactory = new HandlerInfoChainFactory(handlerInfos);
        service.setOption("handlerInfoChain", (Object)handlerInfoChainFactory);
        AxisWsContainer container = new AxisWsContainer(port.getWsdlUrl(), service, null, classLoader);
        this.wsContainers.put(serviceId, container);
        return container;
    }

    protected void destroyPojoWsContainer(String serviceId) {
        AxisWsContainer container = this.wsContainers.remove(serviceId);
        if (container != null) {
            container.destroy();
        }
    }

    private List<HandlerInfo> createHandlerInfos(List<HandlerChainData> handlerChains) throws ClassNotFoundException {
        if (handlerChains == null || handlerChains.isEmpty()) {
            return null;
        }
        List handlers = handlerChains.get(0).getHandlers();
        ArrayList<HandlerInfo> handlerInfos = new ArrayList<HandlerInfo>(handlers.size());
        for (HandlerData handler : handlers) {
            Class handlerClass = handler.getHandlerClass();
            HashMap<Object, Object> initParams = new HashMap<Object, Object>(handler.getInitParams());
            QName[] headers = handler.getSoapHeaders().toArray(new QName[handler.getSoapHeaders().size()]);
            HandlerInfo handlerInfo = new HandlerInfo(handlerClass, initParams, headers);
            handlerInfos.add(handlerInfo);
        }
        return handlerInfos;
    }
}

