/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.axis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.providers.java.RPCProvider;
import org.apache.axis.utils.JavaUtils;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.InvalidateReferenceException;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.server.ServerRuntimeException;
import org.apache.openejb.server.axis.HandlerChainImpl;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EjbRpcProvider
extends RPCProvider {
    private final BeanContext ejbDeployment;
    private final List<HandlerInfo> handlerInfos;

    public EjbRpcProvider(BeanContext ejbDeployment) {
        this.ejbDeployment = ejbDeployment;
        this.handlerInfos = new ArrayList<HandlerInfo>();
    }

    public EjbRpcProvider(BeanContext ejbDeployment, List<HandlerInfo> handlerInfos) {
        this.ejbDeployment = ejbDeployment;
        this.handlerInfos = handlerInfos;
    }

    public void processMessage(org.apache.axis.MessageContext msgContext, SOAPEnvelope reqEnv, SOAPEnvelope resEnv, Object obj) throws Exception {
        RPCElement body = this.getBody(reqEnv, msgContext);
        OperationDesc operation = this.getOperationDesc(msgContext, body);
        AxisRpcInterceptor interceptor = new AxisRpcInterceptor(operation, msgContext);
        SOAPMessage message = msgContext.getMessage();
        try {
            message.getSOAPPart().getEnvelope();
            msgContext.setProperty("axis.form.optimization", (Object)Boolean.FALSE);
            RpcContainer container = (RpcContainer)this.ejbDeployment.getContainer();
            Object[] arguments = new Object[]{msgContext, interceptor};
            Class callInterface = this.ejbDeployment.getServiceEndpointInterface();
            Object result = container.invoke(this.ejbDeployment.getDeploymentID(), InterfaceType.SERVICE_ENDPOINT, callInterface, operation.getMethod(), arguments, null);
            interceptor.createResult(result);
        }
        catch (InvalidateReferenceException e) {
            interceptor.createExceptionResult(e.getCause());
        }
        catch (ApplicationException e) {
            interceptor.createExceptionResult(e.getCause());
        }
        catch (Throwable throwable) {
            throw new AxisFault("Web Service EJB Invocation failed: method " + operation.getMethod(), throwable);
        }
    }

    public Object getServiceObject(org.apache.axis.MessageContext msgContext, Handler service, String clsName, IntHolder scopeHolder) throws Exception {
        return this.ejbDeployment;
    }

    public class AxisRpcInterceptor {
        private OperationDesc operation;
        private org.apache.axis.MessageContext messageContext;

        public AxisRpcInterceptor(OperationDesc operation, org.apache.axis.MessageContext msgContext) throws Exception {
            this.messageContext = msgContext;
            this.operation = operation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @AroundInvoke
        public Object intercept(InvocationContext context) throws Exception {
            HandlerChainImpl handlerChain = new HandlerChainImpl(EjbRpcProvider.this.handlerInfos);
            try {
                Object invocationResult = null;
                try {
                    if (handlerChain.handleRequest((MessageContext)this.messageContext)) {
                        context.setParameters(this.getArguments());
                        invocationResult = context.proceed();
                        if (!handlerChain.isEmpty()) {
                            this.createResult(invocationResult);
                        }
                    } else {
                        invocationResult = null;
                    }
                }
                catch (SOAPFaultException e) {
                    handlerChain.handleFault((MessageContext)this.messageContext);
                    throw e;
                }
                handlerChain.handleResponse((MessageContext)this.messageContext);
                if (!handlerChain.isEmpty()) {
                    try {
                        invocationResult = this.demarshallResult();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                Object object = invocationResult;
                return object;
            }
            finally {
                handlerChain.destroy();
            }
        }

        public Object[] getArguments() {
            try {
                return this.demarshallArguments();
            }
            catch (Exception e) {
                throw (IllegalStateException)new IllegalStateException("Cannot demarshal the soap parts into arguments").initCause(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] demarshallArguments() throws Exception {
            SOAPMessage message = this.messageContext.getMessage();
            this.messageContext.setProperty("axis.form.optimization", (Object)Boolean.TRUE);
            if (message != null) {
                message.saveChanges();
            }
            try {
                Message reqMsg = this.messageContext.getRequestMessage();
                SOAPEnvelope requestEnvelope = reqMsg.getSOAPEnvelope();
                RPCElement body = EjbRpcProvider.this.getBody(requestEnvelope, this.messageContext);
                body.setNeedDeser(true);
                Vector args = null;
                try {
                    args = body.getParams();
                }
                catch (SAXException e) {
                    if (e.getException() != null) {
                        throw e.getException();
                    }
                    throw e;
                }
                Object[] argValues = new Object[this.operation.getNumParams()];
                for (int i = 0; i < args.size(); ++i) {
                    RPCParam rpcParam = (RPCParam)args.get(i);
                    Object value = rpcParam.getObjectValue();
                    ParameterDesc paramDesc = rpcParam.getParamDesc();
                    if (paramDesc != null && paramDesc.getJavaType() != null) {
                        value = JavaUtils.convert((Object)value, (Class)paramDesc.getJavaType());
                        rpcParam.setObjectValue(value);
                    }
                    int order = paramDesc == null || paramDesc.getOrder() == -1 ? i : paramDesc.getOrder();
                    argValues[order] = value;
                }
                Object[] objectArray = argValues;
                return objectArray;
            }
            finally {
                this.messageContext.setProperty("axis.form.optimization", (Object)Boolean.FALSE);
            }
        }

        private Object demarshallResult() throws Exception {
            Message resMsg = this.messageContext.getResponseMessage();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            resMsg.writeTo((OutputStream)out);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            DeserializationContext dser = new DeserializationContext(new InputSource(in), resMsg.getMessageContext(), null);
            dser.parse();
            SOAPEnvelope responseEnvelope = dser.getEnvelope();
            SOAPBodyElement bodyEl = responseEnvelope.getFirstBody();
            if (bodyEl == null) {
                return null;
            }
            QName returnType = this.operation.getReturnType();
            if (XMLType.AXIS_VOID.equals(returnType)) {
                return null;
            }
            Object result = null;
            if (bodyEl instanceof RPCElement) {
                RPCElement body = (RPCElement)bodyEl;
                body.setNeedDeser(true);
                Vector args = null;
                try {
                    args = body.getParams();
                }
                catch (SAXException e) {
                    if (e.getException() != null) {
                        throw e.getException();
                    }
                    throw e;
                }
                QName returnParamQName = this.operation.getReturnQName();
                if (args != null && args.size() > 0) {
                    if (returnParamQName == null) {
                        RPCParam param = (RPCParam)args.get(0);
                        result = param.getObjectValue();
                    } else {
                        for (int i = 0; i < args.size(); ++i) {
                            RPCParam param = (RPCParam)args.get(i);
                            if (!returnParamQName.equals(param.getQName())) continue;
                            result = param.getObjectValue();
                            break;
                        }
                    }
                }
            } else {
                try {
                    result = bodyEl.getValueAsType(returnType);
                }
                catch (Exception e) {
                    result = bodyEl;
                }
            }
            if (this.operation.getReturnClass() != null) {
                result = JavaUtils.convert((Object)result, (Class)this.operation.getReturnClass());
            }
            return result;
        }

        public void createResult(Object object) {
            this.messageContext.setPastPivot(true);
            try {
                Message requestMessage = this.messageContext.getRequestMessage();
                SOAPEnvelope requestEnvelope = requestMessage.getSOAPEnvelope();
                RPCElement requestBody = EjbRpcProvider.this.getBody(requestEnvelope, this.messageContext);
                Message responseMessage = this.messageContext.getResponseMessage();
                SOAPEnvelope responseEnvelope = responseMessage.getSOAPEnvelope();
                ServiceDesc serviceDescription = this.messageContext.getService().getServiceDescription();
                RPCElement responseBody = EjbRpcProvider.this.createResponseBody(requestBody, this.messageContext, this.operation, serviceDescription, object, responseEnvelope, this.getInOutParams());
                responseEnvelope.removeBody();
                responseEnvelope.addBodyElement((SOAPBodyElement)responseBody);
            }
            catch (Exception e) {
                throw new ServerRuntimeException("Failed while creating response message body", (Throwable)e);
            }
        }

        public void createExceptionResult(Throwable exception) {
            this.messageContext.setPastPivot(true);
            AxisFault axisFault = null;
            if (exception instanceof Exception) {
                axisFault = AxisFault.makeFault((Exception)((Exception)exception));
                axisFault.setFaultCodeAsString("Server.generalException");
            } else {
                axisFault = new AxisFault("Server", "Server Error", null, null);
            }
            SOAPFault fault = new SOAPFault(axisFault);
            SOAPEnvelope envelope = new SOAPEnvelope();
            envelope.addBodyElement((SOAPBodyElement)fault);
            Message message = new Message((Object)envelope);
            message.setMessageType("response");
            this.messageContext.setResponseMessage(message);
        }

        public ArrayList getInOutParams() {
            return new ArrayList();
        }
    }
}

