/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.axis.assembler;

public enum BindingStyle {
    RPC_LITERAL(false, true, false),
    RPC_ENCODED(false, false, false),
    DOCUMENT_LITERAL(true, true, false),
    DOCUMENT_ENCODED(true, false, false),
    DOCUMENT_LITERAL_WRAPPED(true, true, true);

    private final boolean document;
    private final boolean literal;
    private final boolean wrapped;

    private BindingStyle(boolean document, boolean literal, boolean wrapped) {
        this.document = document;
        this.literal = literal;
        this.wrapped = wrapped;
    }

    public boolean isRpc() {
        return !this.document;
    }

    public boolean isDocument() {
        return this.document;
    }

    public boolean isEncoded() {
        return !this.literal;
    }

    public boolean isLiteral() {
        return this.literal;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public static BindingStyle getBindingStyle(String style, String use) {
        if ("rpc".equalsIgnoreCase(style)) {
            if (use == null || "encoded".equalsIgnoreCase(use)) {
                return RPC_ENCODED;
            }
            if ("literal".equalsIgnoreCase(use)) {
                return RPC_LITERAL;
            }
            throw new IllegalArgumentException("Use must be literal or encoded: " + use);
        }
        if ("document".equalsIgnoreCase(style)) {
            if (use == null || "encoded".equalsIgnoreCase(use)) {
                return DOCUMENT_ENCODED;
            }
            if ("literal".equalsIgnoreCase(use)) {
                return DOCUMENT_LITERAL;
            }
            throw new IllegalArgumentException("Use must be literal or encoded: " + use);
        }
        throw new IllegalArgumentException("Style must rpc or document: " + style);
    }
}

