/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.axis.assembler;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.server.axis.assembler.CommonsSchemaLoader;
import org.apache.openejb.server.axis.assembler.XmlElementInfo;
import org.apache.openejb.server.axis.assembler.XmlSchemaInfo;
import org.apache.openejb.server.axis.assembler.XmlTypeInfo;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.apache.ws.commons.schema.XmlSchemaGroupBase;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CommonsSchemaInfoBuilder {
    private static final Log log = LogFactory.getLog(CommonsSchemaInfoBuilder.class);
    private static final String XML_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static final String XML_NS_NS = "http://www.w3.org/2000/xmlns/";
    private static final String SOAP_ENCODING_NS = "http://schemas.xmlsoap.org/soap/encoding/";
    private static final QName SOAP_ARRAY = new QName("http://schemas.xmlsoap.org/soap/encoding/", "Array");
    private static final QName SOAP_ARRAY_TYPE = new QName("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
    private static final QName WSDL_ARRAY_TYPE = new QName("http://schemas.xmlsoap.org/wsdl/", "arrayType");
    private final XmlSchemaCollection xmlSchemaCollection;
    private final Map<QName, XmlTypeInfo> xmlTypes = new HashMap<QName, XmlTypeInfo>();
    private final Map<QName, XmlElementInfo> xmlElements = new HashMap<QName, XmlElementInfo>();

    public CommonsSchemaInfoBuilder(JarFile moduleFile, URI wsdlUri) throws OpenEJBException {
        if (moduleFile == null) {
            throw new NullPointerException("moduleFile is null");
        }
        if (wsdlUri == null) {
            throw new NullPointerException("wsdlUri is null");
        }
        CommonsSchemaLoader schemaLoader = new CommonsSchemaLoader(wsdlUri, moduleFile);
        this.xmlSchemaCollection = schemaLoader.loadSchema();
    }

    public CommonsSchemaInfoBuilder(XmlSchemaCollection xmlSchemaCollection) {
        if (xmlSchemaCollection == null) {
            throw new NullPointerException("schemaTypeSystem is null");
        }
        this.xmlSchemaCollection = xmlSchemaCollection;
    }

    public XmlSchemaInfo createSchemaInfo() throws OpenEJBException {
        this.buildXmlTypeInfos();
        XmlSchemaInfo schemaInfo = new XmlSchemaInfo();
        schemaInfo.types.putAll(this.xmlTypes);
        schemaInfo.elements.putAll(this.xmlElements);
        return schemaInfo;
    }

    private void buildXmlTypeInfos() {
        for (XmlSchema schema : this.xmlSchemaCollection.getXmlSchemas()) {
            Iterator iterator = schema.getElements().getValues();
            while (iterator.hasNext()) {
                XmlSchemaElement globalElement = (XmlSchemaElement)iterator.next();
                this.addGlobalElement(globalElement);
            }
            iterator = schema.getSchemaTypes().getValues();
            while (iterator.hasNext()) {
                XmlSchemaType globalType = (XmlSchemaType)iterator.next();
                this.addType(globalType.getQName(), globalType);
            }
        }
    }

    private void addGlobalElement(XmlSchemaElement element) {
        QName xmlType = element.getSchemaTypeName();
        if (xmlType == null) {
            xmlType = new QName(element.getQName().getNamespaceURI(), ">" + element.getQName().getLocalPart());
            this.addType(xmlType, element.getSchemaType());
        }
        XmlElementInfo elementInfo = CommonsSchemaInfoBuilder.createXmlElementInfo(element.getQName(), xmlType, element);
        this.xmlElements.put(element.getQName(), elementInfo);
    }

    private static XmlElementInfo createXmlElementInfo(QName qname, QName xmlType, XmlSchemaElement element) {
        XmlElementInfo elementInfo = new XmlElementInfo();
        elementInfo.qname = qname;
        elementInfo.xmlType = xmlType;
        elementInfo.minOccurs = element.getMinOccurs();
        elementInfo.maxOccurs = element.getMaxOccurs();
        elementInfo.nillable = element.isNillable();
        return elementInfo;
    }

    private void addType(QName typeQName, XmlSchemaType type) {
        if (XML_SCHEMA_NS.equals(typeQName.getNamespaceURI())) {
            return;
        }
        XmlTypeInfo typeInfo = CommonsSchemaInfoBuilder.createXmlTypeInfo(typeQName, type);
        this.xmlTypes.put(typeQName, typeInfo);
        if (type instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType complexType = (XmlSchemaComplexType)type;
            List<XmlSchemaElement> elements = CommonsSchemaInfoBuilder.getNestedElements(complexType);
            for (XmlSchemaElement element : elements) {
                this.addNestedElement(element, typeInfo);
            }
        }
    }

    private void addNestedElement(XmlSchemaElement element, XmlTypeInfo enclosingType) {
        QName typeQName;
        QName elementQName;
        if (element.getRefName() == null) {
            String elementNamespace = element.getQName().getNamespaceURI();
            if (elementNamespace == null || elementNamespace.equals("")) {
                elementNamespace = enclosingType.qname.getNamespaceURI();
            }
            elementQName = new QName(elementNamespace, element.getQName().getLocalPart());
            if (element.getSchemaTypeName() != null) {
                typeQName = element.getSchemaTypeName();
            } else {
                String anonymoustName = enclosingType.qname.getLocalPart() + ">" + elementQName.getLocalPart();
                QName anonymousQName = new QName(elementNamespace, anonymoustName);
                typeQName = new QName(elementNamespace, ">" + anonymousQName.getLocalPart());
                this.addType(typeQName, element.getSchemaType());
            }
        } else {
            XmlSchemaElement refElement = this.xmlSchemaCollection.getElementByQName(element.getRefName());
            elementQName = refElement.getQName();
            typeQName = refElement.getSchemaTypeName();
        }
        XmlElementInfo nestedElement = CommonsSchemaInfoBuilder.createXmlElementInfo(elementQName, typeQName, element);
        enclosingType.elements.put(nestedElement.qname, nestedElement);
    }

    public static XmlTypeInfo createXmlTypeInfo(QName qname, XmlSchemaType type) {
        if (qname == null) {
            throw new NullPointerException("qname is null");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        XmlTypeInfo typeInfo = new XmlTypeInfo();
        typeInfo.qname = qname;
        boolean bl = typeInfo.anonymous = qname.getLocalPart().indexOf(62) >= 0;
        if (type instanceof XmlSchemaSimpleType) {
            XmlSchemaSimpleType simpleType = (XmlSchemaSimpleType)type;
            XmlSchemaSimpleTypeContent content = simpleType.getContent();
            if (content instanceof XmlSchemaSimpleTypeList) {
                XmlSchemaSimpleTypeList list = (XmlSchemaSimpleTypeList)content;
                typeInfo.simpleBaseType = list.getItemType().getQName();
                typeInfo.listType = true;
            } else if (content instanceof XmlSchemaSimpleTypeRestriction) {
                XmlSchemaSimpleTypeRestriction restriction = (XmlSchemaSimpleTypeRestriction)content;
                typeInfo.simpleBaseType = restriction.getBaseTypeName();
                Iterator iterator = restriction.getFacets().getIterator();
                while (iterator.hasNext()) {
                    if (!(iterator.next() instanceof XmlSchemaEnumerationFacet)) continue;
                    typeInfo.enumType = true;
                    break;
                }
            }
        } else if (type instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType complexType = (XmlSchemaComplexType)type;
            typeInfo.arrayComponentType = CommonsSchemaInfoBuilder.extractSoapArrayComponentType(complexType);
            if (!CommonsSchemaInfoBuilder.isSoapArray(complexType)) {
                XmlSchemaObjectCollection attributes = complexType.getAttributes();
                Iterator iterator = attributes.getIterator();
                while (iterator.hasNext()) {
                    XmlSchemaAttribute attribute;
                    QName old;
                    Object item = iterator.next();
                    if (!(item instanceof XmlSchemaAttribute) || (old = typeInfo.attributes.put((attribute = (XmlSchemaAttribute)item).getQName().getLocalPart(), attribute.getSchemaTypeName())) == null) continue;
                    throw new IllegalArgumentException("Complain to your expert group member, spec does not support attributes with the same local name and differing namespaces: original: " + old + ", duplicate local name: " + attribute);
                }
            }
        } else {
            log.warn((Object)("Unknown schema type class " + ((Object)((Object)typeInfo)).getClass().getName()));
        }
        return typeInfo;
    }

    private static boolean isSoapArray(XmlSchemaComplexType complexType) {
        XmlSchemaContentModel contentModel = complexType.getContentModel();
        if (contentModel == null) {
            return false;
        }
        XmlSchemaContent content = contentModel.getContent();
        if (!(content instanceof XmlSchemaComplexContentRestriction)) {
            return false;
        }
        XmlSchemaComplexContentRestriction restriction = (XmlSchemaComplexContentRestriction)content;
        return SOAP_ARRAY.equals(restriction.getBaseTypeName());
    }

    private static QName extractSoapArrayComponentType(XmlSchemaComplexType complexType) {
        if (!CommonsSchemaInfoBuilder.isSoapArray(complexType)) {
            return null;
        }
        XmlSchemaComplexContentRestriction restriction = (XmlSchemaComplexContentRestriction)complexType.getContentModel().getContent();
        XmlSchemaObjectCollection attributes = restriction.getAttributes();
        Iterator iterator = attributes.getIterator();
        while (iterator.hasNext()) {
            XmlSchemaAttribute attribute;
            Object item = iterator.next();
            if (!(item instanceof XmlSchemaAttribute) || !(attribute = (XmlSchemaAttribute)item).getRefName().equals(SOAP_ARRAY_TYPE)) continue;
            for (Attr attr : attribute.getUnhandledAttributes()) {
                QName componentType;
                QName attQName = new QName(attr.getNamespaceURI(), attr.getLocalName());
                if (!WSDL_ARRAY_TYPE.equals(attQName)) continue;
                String value = attr.getValue();
                int pos = value.lastIndexOf(":");
                if (pos < 0) {
                    componentType = new QName("", value);
                } else {
                    String localPart = value.substring(pos + 1);
                    String prefix = value.substring(0, pos);
                    String namespace = CommonsSchemaInfoBuilder.getNamespaceForPrefix(prefix, attr.getOwnerElement());
                    componentType = new QName(namespace, localPart);
                }
                log.debug((Object)"determined component type from element type");
                return componentType;
            }
        }
        XmlSchemaParticle particle = restriction.getParticle();
        if (particle instanceof XmlSchemaSequence) {
            XmlSchemaSequence sequence = (XmlSchemaSequence)particle;
            if (sequence.getItems().getCount() != 1) {
                throw new IllegalArgumentException("more than one element inside array definition: " + complexType);
            }
            XmlSchemaObject item = sequence.getItems().getItem(0);
            if (item instanceof XmlSchemaElement) {
                XmlSchemaElement element = (XmlSchemaElement)item;
                QName componentType = element.getSchemaTypeName();
                log.debug((Object)"determined component type from element type");
                return componentType;
            }
        }
        return null;
    }

    private static String getNamespaceForPrefix(String prefix, Element element) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr;
            Node node = attributes.item(i);
            if (!(node instanceof Attr) || !XML_NS_NS.equals((attr = (Attr)node).getNamespaceURI()) || !attr.getLocalName().equals(prefix)) continue;
            return attr.getValue();
        }
        if (element.getParentNode() instanceof Element) {
            return CommonsSchemaInfoBuilder.getNamespaceForPrefix(prefix, (Element)element.getParentNode());
        }
        return prefix;
    }

    private static List<XmlSchemaElement> getNestedElements(XmlSchemaComplexType complexType) {
        ArrayList<XmlSchemaElement> elements = new ArrayList<XmlSchemaElement>();
        XmlSchemaParticle particle = complexType.getParticle();
        if (particle instanceof XmlSchemaElement) {
            XmlSchemaElement element = (XmlSchemaElement)particle;
            elements.add(element);
        } else if (particle instanceof XmlSchemaGroupBase && !(particle instanceof XmlSchemaChoice)) {
            XmlSchemaGroupBase groupBase = (XmlSchemaGroupBase)particle;
            Iterator iterator = groupBase.getItems().getIterator();
            while (iterator.hasNext()) {
                XmlSchemaParticle child = (XmlSchemaParticle)iterator.next();
                if (!(child instanceof XmlSchemaElement)) continue;
                XmlSchemaElement element = (XmlSchemaElement)child;
                elements.add(element);
            }
        }
        return elements;
    }
}

