/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.axis.client;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.wsdl.OperationType;
import javax.xml.rpc.holders.Holder;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.axis.client.Call;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.utils.JavaUtils;
import org.apache.openejb.server.ServerRuntimeException;
import org.apache.openejb.server.axis.client.GenericServiceEndpoint;
import org.apache.openejb.server.axis.client.OperationInfo;
import org.apache.openejb.server.webservices.saaj.SaajUniverse;

public class ServiceEndpointMethodInterceptor
implements MethodInterceptor {
    private final GenericServiceEndpoint stub;
    private final OperationInfo[] operations;
    private final String credentialsName;

    public ServiceEndpointMethodInterceptor(GenericServiceEndpoint stub, OperationInfo[] operations, String credentialsName) {
        this.stub = stub;
        this.operations = operations;
        this.credentialsName = credentialsName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        SaajUniverse universe = new SaajUniverse();
        universe.set(SaajUniverse.AXIS1);
        try {
            Object object = this.doIntercept(method, objects, methodProxy);
            return object;
        }
        finally {
            universe.unset();
        }
    }

    private Object doIntercept(Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        int index = methodProxy.getSuperIndex();
        OperationInfo operationInfo = this.operations[index];
        if (operationInfo == null) {
            throw new ServerRuntimeException("Operation not mapped: " + method.getName() + " index: " + index + "\n OperationInfos: " + Arrays.asList(this.operations));
        }
        this.stub.checkCachedEndpoint();
        Call call = this.stub.createCall();
        operationInfo.prepareCall(call);
        this.stub.setUpCall(call);
        if (this.credentialsName != null) {
            throw new UnsupportedOperationException("Client side auth is not implementd");
        }
        Object response = null;
        ArrayList parameterDescs = operationInfo.getOperationDesc().getParameters();
        Object[] unwrapped = this.extractFromHolders(objects, parameterDescs, operationInfo.getOperationDesc().getNumInParams());
        if (operationInfo.getOperationDesc().getMep() == OperationType.REQUEST_RESPONSE) {
            try {
                response = call.invoke(unwrapped);
            }
            catch (RemoteException e) {
                throw operationInfo.unwrapFault(e);
            }
            if (response instanceof RemoteException) {
                throw operationInfo.unwrapFault((RemoteException)response);
            }
            this.stub.extractAttachments(call);
            Map outputParameters = call.getOutputParams();
            this.putInHolders(outputParameters, objects, parameterDescs);
            Class returnType = operationInfo.getOperationDesc().getReturnClass();
            if (response == null || returnType == null || returnType.isAssignableFrom(response.getClass())) {
                return response;
            }
            return JavaUtils.convert((Object)response, (Class)returnType);
        }
        if (operationInfo.getOperationDesc().getMep() == OperationType.ONE_WAY) {
            call.invokeOneWay(unwrapped);
            return null;
        }
        throw new ServerRuntimeException("Invalid messaging style: " + operationInfo.getOperationDesc().getMep());
    }

    private Object[] extractFromHolders(Object[] objects, List parameterDescs, int inParameterCount) throws JavaUtils.HolderException {
        if (objects.length != parameterDescs.size()) {
            throw new IllegalArgumentException("Mismatch parameter count: expected: " + parameterDescs.size() + ", actual: " + objects.length);
        }
        Object[] unwrapped = new Object[inParameterCount];
        int j = 0;
        for (int i = 0; objects != null && i < objects.length; ++i) {
            Object parameter = objects[i];
            ParameterDesc parameterDesc = (ParameterDesc)parameterDescs.get(i);
            if (parameterDesc.getMode() == 3) {
                unwrapped[j++] = JavaUtils.getHolderValue((Object)parameter);
                continue;
            }
            if (parameterDesc.getMode() != 1) continue;
            unwrapped[j++] = parameter;
        }
        return unwrapped;
    }

    private void putInHolders(Map outputParameters, Object[] objects, List parameterDescs) throws JavaUtils.HolderException {
        for (int i = 0; i < objects.length; ++i) {
            Object parameter = objects[i];
            ParameterDesc parameterDesc = (ParameterDesc)parameterDescs.get(i);
            if (parameterDesc.getMode() != 3 && parameterDesc.getMode() != 2) continue;
            Object returned = outputParameters.get(parameterDesc.getQName());
            if (returned instanceof Holder) {
                returned = JavaUtils.getHolderValue(returned);
            }
            JavaUtils.setHolderValue((Object)parameter, returned);
        }
    }
}

