/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.axis;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.openejb.server.ServerRuntimeException;

public class HandlerChainImpl
extends ArrayList
implements HandlerChain {
    private String[] roles;
    private LinkedList<Handler> invokedHandlers = new LinkedList();

    public HandlerChainImpl(List<HandlerInfo> handlerInfos) {
        this(handlerInfos, null);
    }

    public HandlerChainImpl(List<HandlerInfo> handlerInfos, String[] roles) {
        this.roles = roles;
        for (int i = 0; i < handlerInfos.size(); ++i) {
            HandlerInfo handlerInfo = handlerInfos.get(i);
            try {
                Handler handler = (Handler)handlerInfo.getHandlerClass().newInstance();
                handler.init(handlerInfo);
                this.add(handler);
                continue;
            }
            catch (Exception e) {
                throw new JAXRPCException("Unable to initialize handler class: " + handlerInfo.getHandlerClass().getName(), (Throwable)e);
            }
        }
    }

    public String[] getRoles() {
        return this.roles;
    }

    public void setRoles(String[] roles) {
        this.roles = roles == null ? new String[0] : roles;
    }

    public void init(Map map) {
    }

    public void destroy() {
        for (Handler handler : this.invokedHandlers) {
            handler.destroy();
        }
        this.invokedHandlers.clear();
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleRequest(MessageContext context) {
        MessageSnapshot snapshot = new MessageSnapshot(context);
        try {
            for (int i = 0; i < this.size(); ++i) {
                Handler currentHandler = (Handler)this.get(i);
                this.invokedHandlers.addFirst(currentHandler);
                if (currentHandler.handleRequest(context)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.saveChanges(context);
        }
        if (!snapshot.equals(context)) {
            throw new IllegalStateException("The soap message operation or arguments were illegally modified by the HandlerChain");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleResponse(MessageContext context) {
        MessageSnapshot snapshot = new MessageSnapshot(context);
        try {
            for (Handler handler : this.invokedHandlers) {
                if (handler.handleResponse(context)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.saveChanges(context);
        }
        if (!snapshot.equals(context)) {
            throw new IllegalStateException("The soap message operation or arguments were illegally modified by the HandlerChain");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleFault(MessageContext context) {
        MessageSnapshot snapshot = new MessageSnapshot(context);
        try {
            for (Handler handler : this.invokedHandlers) {
                if (handler.handleFault(context)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.saveChanges(context);
        }
        if (!snapshot.equals(context)) {
            throw new IllegalStateException("The soap message operation or arguments were illegally modified by the HandlerChain");
        }
        return true;
    }

    private void saveChanges(MessageContext context) {
        try {
            SOAPMessage message = ((SOAPMessageContext)context).getMessage();
            if (message != null) {
                message.saveChanges();
            }
        }
        catch (SOAPException e) {
            throw new ServerRuntimeException("Unable to save changes to SOAPMessage : " + e.toString());
        }
    }

    static class MessageSnapshot {
        private final String operationName;
        private final List<String> parameterNames;

        public MessageSnapshot(MessageContext soapMessage) {
            SOAPMessage message = ((SOAPMessageContext)soapMessage).getMessage();
            if (message == null || message.getSOAPPart() == null) {
                this.operationName = null;
                this.parameterNames = null;
            } else {
                SOAPBody body = this.getBody(message);
                SOAPElement operation = (SOAPElement)body.getChildElements().next();
                this.operationName = operation.getElementName().toString();
                this.parameterNames = new ArrayList<String>();
                Iterator i = operation.getChildElements();
                while (i.hasNext()) {
                    SOAPElement parameter = (SOAPElement)i.next();
                    String element = parameter.getElementName().toString();
                    this.parameterNames.add(element);
                }
            }
        }

        private SOAPBody getBody(SOAPMessage message) {
            try {
                return message.getSOAPPart().getEnvelope().getBody();
            }
            catch (SOAPException e) {
                throw new ServerRuntimeException((Exception)((Object)e));
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof SOAPMessageContext && this.equals((SOAPMessageContext)obj);
        }

        private boolean equals(SOAPMessageContext soapMessage) {
            SOAPMessage message = soapMessage.getMessage();
            if (this.operationName == null) {
                return message == null || message.getSOAPPart() == null;
            }
            SOAPBody body = this.getBody(message);
            SOAPElement operation = (SOAPElement)body.getChildElements().next();
            if (!this.operationName.equals(operation.getElementName().toString())) {
                return false;
            }
            Iterator parameters = operation.getChildElements();
            Iterator<String> i = this.parameterNames.iterator();
            while (i.hasNext()) {
                if (!parameters.hasNext()) {
                    return false;
                }
                String original = i.next();
                SOAPElement parameter = (SOAPElement)parameters.next();
                if (parameter != null && original.equals(parameter.getElementName().toString())) continue;
                return false;
            }
            return !parameters.hasNext();
        }
    }
}

