/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.openejb.client.ClusterMetaData;
import org.apache.openejb.client.Response;

public class ClusterResponse
implements Response {
    private Code responseCode;
    private ClusterMetaData updatedMetaData;
    private Throwable failure;

    public ClusterResponse(Code responseCode) {
        this.responseCode = responseCode;
    }

    public ClusterResponse() {
    }

    public Code getResponseCode() {
        return this.responseCode;
    }

    public void setCurrent() {
        this.responseCode = Code.CURRENT;
    }

    public void setUpdatedMetaData(ClusterMetaData updatedMetaData) {
        this.responseCode = Code.UPDATE;
        this.updatedMetaData = updatedMetaData;
    }

    public ClusterMetaData getUpdatedMetaData() {
        return this.updatedMetaData;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public void setFailure(Throwable failure) {
        this.responseCode = Code.FAILURE;
        this.failure = failure;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte i = in.readByte();
        this.responseCode = Code.values()[i];
        switch (this.responseCode) {
            case CURRENT: {
                break;
            }
            case UPDATE: {
                this.updatedMetaData = new ClusterMetaData();
                this.updatedMetaData.readExternal(in);
                break;
            }
            case FAILURE: {
                this.failure = (IOException)in.readObject();
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.responseCode.ordinal());
        switch (this.responseCode) {
            case CURRENT: {
                break;
            }
            case UPDATE: {
                this.updatedMetaData.writeExternal(out);
                break;
            }
            case FAILURE: {
                out.writeObject(this.failure);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Code {
        CURRENT,
        UPDATE,
        FAILURE;

    }
}

