/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.openejb.client.ClusterableResponse;
import org.apache.openejb.client.DataSourceMetaData;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.InjectionMetaData;
import org.apache.openejb.client.NameClassPairEnumeration;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.WsMetaData;

public class JNDIResponse
implements ClusterableResponse {
    private transient int responseCode = -1;
    private transient Object result;
    private transient ServerMetaData server;

    public JNDIResponse() {
    }

    public JNDIResponse(int code, Object obj) {
        this.responseCode = code;
        this.result = obj;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public void setServer(ServerMetaData server) {
        this.server = server;
    }

    public ServerMetaData getServer() {
        return this.server;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        boolean readServer = in.readBoolean();
        if (readServer) {
            this.server = new ServerMetaData();
            this.server.readExternal(in);
        }
        this.responseCode = in.readByte();
        switch (this.responseCode) {
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: {
                this.result = in.readObject();
                break;
            }
            case 14: 
            case 16: {
                break;
            }
            case 13: {
                EJBMetaDataImpl m = new EJBMetaDataImpl();
                m.readExternal(in);
                this.result = m;
                break;
            }
            case 22: {
                DataSourceMetaData ds = new DataSourceMetaData();
                ds.readExternal(in);
                this.result = ds;
                break;
            }
            case 23: {
                InjectionMetaData imd = new InjectionMetaData();
                imd.readExternal(in);
                this.result = imd;
                break;
            }
            case 25: {
                WsMetaData ws = (WsMetaData)in.readObject();
                this.result = ws;
                break;
            }
            case 15: {
                NameClassPairEnumeration ncpe = new NameClassPairEnumeration();
                ncpe.readExternal(in);
                this.result = ncpe;
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        if (null != this.server) {
            out.writeBoolean(true);
            this.server.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeByte((byte)this.responseCode);
        switch (this.responseCode) {
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: {
                out.writeObject(this.result);
                break;
            }
            case 14: 
            case 16: {
                break;
            }
            case 13: {
                EJBMetaDataImpl m = (EJBMetaDataImpl)this.result;
                m.writeExternal(out);
                break;
            }
            case 22: {
                DataSourceMetaData ds = (DataSourceMetaData)this.result;
                ds.writeExternal(out);
                break;
            }
            case 23: {
                InjectionMetaData imd = (InjectionMetaData)this.result;
                imd.writeExternal(out);
                break;
            }
            case 25: {
                WsMetaData ws = (WsMetaData)this.result;
                out.writeObject(ws);
                break;
            }
            case 15: {
                NameClassPairEnumeration ncpe = (NameClassPairEnumeration)this.result;
                ncpe.writeExternal(out);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        switch (this.responseCode) {
            case 21: {
                sb.append("JNDI_BUSINESS_OBJECT:");
                break;
            }
            case 12: {
                sb.append("JNDI_OK:");
                break;
            }
            case 17: {
                sb.append("JNDI_NAMING_EXCEPTION:");
                break;
            }
            case 18: {
                sb.append("JNDI_RUNTIME_EXCEPTION:");
                break;
            }
            case 19: {
                sb.append("JNDI_ERROR:");
                break;
            }
            case 24: {
                sb.append("JNDI_RESOURCE:");
                break;
            }
            case 14: {
                sb.append("JNDI_CONTEXT:");
                break;
            }
            case 16: {
                sb.append("JNDI_NOT_FOUND:");
                break;
            }
            case 13: {
                sb.append("JNDI_EJBHOME:");
                break;
            }
            case 22: {
                sb.append("JNDI_DATA_SOURCE:");
                break;
            }
            case 23: {
                sb.append("JNDI_INJECTIONS:");
            }
        }
        sb.append(this.getResult());
        return sb.toString();
    }
}

