/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options {
    private final Options parent;
    private final Properties properties;

    public Options(Properties properties) {
        this(properties, new NullOptions());
    }

    public Options(Properties properties, Options parent) {
        this.parent = parent;
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setLogger(Log logger) {
        this.parent.setLogger(logger);
    }

    public Log getLogger() {
        return this.parent.getLogger();
    }

    public boolean has(String property) {
        return this.properties.containsKey(property) || this.parent.has(property);
    }

    public String get(String property, String defaultValue) {
        String value = this.properties.getProperty(property);
        return value != null ? this.log(property, value) : this.parent.get(property, defaultValue);
    }

    public <T> T get(String property, T defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue");
        }
        String value = this.properties.getProperty(property);
        if (value == null || value.equals("")) {
            return this.parent.get(property, defaultValue);
        }
        try {
            Class<?> type = defaultValue.getClass();
            Constructor<?> constructor = type.getConstructor(String.class);
            Object t = constructor.newInstance(value);
            return (T)this.log(property, t);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.warn(property, value, e);
            return this.parent.get(property, defaultValue);
        }
    }

    public int get(String property, int defaultValue) {
        String value = this.properties.getProperty(property);
        if (value == null || value.equals("")) {
            return this.parent.get(property, defaultValue);
        }
        try {
            return this.log(property, Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            this.warn(property, value, e);
            return this.parent.get(property, defaultValue);
        }
    }

    public long get(String property, long defaultValue) {
        String value = this.properties.getProperty(property);
        if (value == null || value.equals("")) {
            return this.parent.get(property, defaultValue);
        }
        try {
            return this.log(property, Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            this.warn(property, value, e);
            return this.parent.get(property, defaultValue);
        }
    }

    public boolean get(String property, boolean defaultValue) {
        String value = this.properties.getProperty(property);
        if (value == null || value.equals("")) {
            return this.parent.get(property, defaultValue);
        }
        try {
            return this.log(property, Boolean.parseBoolean(value));
        }
        catch (NumberFormatException e) {
            this.warn(property, value, e);
            return this.parent.get(property, defaultValue);
        }
    }

    public Class get(String property, Class defaultValue) {
        String className = this.properties.getProperty(property);
        if (className == null) {
            return this.parent.get(property, defaultValue);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return this.log(property, classLoader.loadClass(className));
        }
        catch (Exception e) {
            this.getLogger().warning("Could not load " + property + " : " + className, e);
            return this.parent.get(property, defaultValue);
        }
    }

    public <T extends Enum<T>> T get(String property, T defaultValue) {
        String value = this.properties.getProperty(property);
        if (value == null || value.equals("")) {
            return this.parent.get(property, defaultValue);
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Must supply a default for property " + property);
        }
        Class<?> enumType = defaultValue.getClass();
        try {
            return (T)((Enum)this.log(property, Options.valueOf(enumType, value.toUpperCase())));
        }
        catch (IllegalArgumentException e) {
            this.warn(property, value);
            return this.parent.get(property, defaultValue);
        }
    }

    public <T extends Enum<T>> Set<T> getAll(String property, T ... defaultValue) {
        EnumSet<T> defaults = EnumSet.copyOf(Arrays.asList(defaultValue));
        return this.getAll(property, (Set<T>)defaults);
    }

    public <T extends Enum<T>> Set<T> getAll(String property, Set<T> defaultValue) {
        Class<?> enumType;
        try {
            Enum t = (Enum)defaultValue.iterator().next();
            enumType = t.getClass();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Must supply a default for property " + property);
        }
        return this.getAll(property, defaultValue, enumType);
    }

    public <T extends Enum<T>> Set<T> getAll(String property, Class<T> enumType) {
        return this.getAll(property, Collections.EMPTY_SET, enumType);
    }

    protected <T extends Enum<T>> Set<T> getAll(String property, Set<T> defaultValue, Class<T> enumType) {
        String value = this.properties.getProperty(property);
        if (value == null || value.equals("")) {
            return this.parent.getAll(property, defaultValue, enumType);
        }
        if ("all".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value)) {
            this.log(property, value);
            return EnumSet.allOf(enumType);
        }
        if ("none".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            this.log(property, value);
            return EnumSet.noneOf(enumType);
        }
        try {
            String[] values = value.split(",");
            EnumSet<T> set = EnumSet.noneOf(enumType);
            for (String s : values) {
                s = s.trim();
                set.add(Options.valueOf(enumType, s.toUpperCase()));
            }
            return this.logAll(property, set);
        }
        catch (IllegalArgumentException e) {
            this.warn(property, value);
            return this.parent.getAll(property, defaultValue, enumType);
        }
    }

    public static <T extends Enum<T>> T valueOf(Class<T> enumType, String name) {
        HashMap<String, Enum> map = new HashMap<String, Enum>();
        for (Enum t : (Enum[])enumType.getEnumConstants()) {
            map.put(t.name().toUpperCase(), t);
        }
        Enum value = (Enum)map.get(name.toUpperCase());
        if (value == null || value.equals("")) {
            Enum.valueOf(enumType, name);
        }
        return (T)value;
    }

    private void warn(String property, String value) {
        this.getLogger().warning("Cannot parse supplied value \"" + value + "\" for option \"" + property + "\"");
    }

    private void warn(String property, String value, Exception e) {
        this.getLogger().warning("Cannot parse supplied value \"" + value + "\" for option \"" + property + "\"", e);
    }

    private <V> V log(String property, V value) {
        if (!this.getLogger().isInfoEnabled()) {
            return value;
        }
        if (value instanceof Class) {
            Class clazz = (Class)value;
            this.getLogger().info("Using '" + property + "=" + clazz.getName() + "'");
        } else {
            this.getLogger().info("Using '" + property + "=" + value + "'");
        }
        return value;
    }

    public <T extends Enum<T>> Set<T> logAll(String property, Set<T> value) {
        if (!this.getLogger().isInfoEnabled()) {
            return value;
        }
        this.getLogger().info("Using '" + property + "=" + Options.join(", ", Options.lowercase(value)) + "'");
        return value;
    }

    protected static <T extends Enum<T>> String[] lowercase(T ... items) {
        String[] values = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            values[i] = ((Enum)items[i]).name().toLowerCase();
        }
        return values;
    }

    protected static <T extends Enum<T>> String[] lowercase(Collection<T> items) {
        String[] values = new String[items.size()];
        int i = 0;
        for (Enum item : items) {
            values[i++] = item.name().toLowerCase();
        }
        return values;
    }

    protected static <V extends Enum<V>> String possibleValues(V v) {
        Class<?> enumType = v.getClass();
        return Options.possibleValues(enumType);
    }

    protected static String possibleValues(Class<? extends Enum> enumType) {
        return Options.join(", ", Options.lowercase((Enum[])enumType.getEnumConstants()));
    }

    public static String join(String delimiter, Object ... collection) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : collection) {
            sb.append(obj).append(delimiter);
        }
        if (collection.length > 0) {
            sb.delete(sb.length() - delimiter.length(), sb.length());
        }
        return sb.toString();
    }

    public static class NullLog
    implements Log {
        public boolean isDebugEnabled() {
            return false;
        }

        public boolean isInfoEnabled() {
            return false;
        }

        public boolean isWarningEnabled() {
            return false;
        }

        public void warning(String message, Throwable t) {
        }

        public void warning(String message) {
        }

        public void debug(String message, Throwable t) {
        }

        public void debug(String message) {
        }

        public void info(String message, Throwable t) {
        }

        public void info(String message) {
        }
    }

    public static interface Log {
        public boolean isDebugEnabled();

        public boolean isInfoEnabled();

        public boolean isWarningEnabled();

        public void warning(String var1, Throwable var2);

        public void warning(String var1);

        public void debug(String var1, Throwable var2);

        public void debug(String var1);

        public void info(String var1, Throwable var2);

        public void info(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NullOptions
    extends Options {
        private Log logger = new NullLog();

        public NullOptions() {
            super(null, null);
        }

        @Override
        public Log getLogger() {
            return this.logger;
        }

        @Override
        public void setLogger(Log logger) {
            this.logger = logger;
        }

        @Override
        public boolean has(String property) {
            return false;
        }

        @Override
        public <T> T get(String property, T defaultValue) {
            return this.log(property, defaultValue);
        }

        @Override
        public int get(String property, int defaultValue) {
            return this.log(property, defaultValue);
        }

        @Override
        public long get(String property, long defaultValue) {
            return this.log(property, defaultValue);
        }

        @Override
        public boolean get(String property, boolean defaultValue) {
            return this.log(property, defaultValue);
        }

        @Override
        public <T extends Enum<T>> T get(String property, T defaultValue) {
            return this.log(property, defaultValue);
        }

        @Override
        public <T extends Enum<T>> Set<T> getAll(String property, T ... defaultValue) {
            return EnumSet.copyOf(Arrays.asList(defaultValue));
        }

        @Override
        protected <T extends Enum<T>> Set<T> getAll(String property, Set<T> defaults, Class<T> enumType) {
            if (this.getLogger().isDebugEnabled()) {
                String possibleValues = "  Possible values are: " + NullOptions.possibleValues(enumType);
                possibleValues = possibleValues + " or NONE or ALL";
                String defaultValues = defaults.size() == 0 ? "NONE" : (defaults.size() == ((Enum[])enumType.getEnumConstants()).length ? "ALL" : NullOptions.join(", ", NullOptions.lowercase(defaults)));
                this.getLogger().debug("Using default '" + property + "=" + defaultValues + "'" + possibleValues);
            }
            return defaults;
        }

        @Override
        public String get(String property, String defaultValue) {
            return this.log(property, defaultValue);
        }

        @Override
        public Class get(String property, Class defaultValue) {
            return this.log(property, defaultValue);
        }

        @Override
        private <V> V log(String property, V value) {
            if (this.getLogger().isDebugEnabled()) {
                if (value instanceof Enum) {
                    Enum anEnum = (Enum)value;
                    this.getLogger().debug("Using default '" + property + "=" + anEnum.name().toLowerCase() + "'.  Possible values are: " + NullOptions.possibleValues(anEnum));
                } else if (value instanceof Class) {
                    Class clazz = (Class)value;
                    this.getLogger().debug("Using default '" + property + "=" + clazz.getName() + "'");
                } else if (value != null) {
                    this.logger.debug("Using default '" + property + "=" + value + "'");
                }
            }
            return value;
        }
    }
}

