/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.openejb.client.ResourceFinder;

public class Registry<T> {
    private Map<String, T> components = new ConcurrentHashMap<String, T>();
    private Map<String, Class> available;
    private String componentType;

    public static <T> Registry<T> create(Class<T> type) {
        return new Registry<T>(type);
    }

    private Registry(Class<T> type) {
        this.componentType = type.getSimpleName();
        try {
            ResourceFinder resourceFinder = new ResourceFinder("META-INF/");
            this.available = resourceFinder.mapAvailableImplementations(type);
        }
        catch (IOException e) {
            this.available = new HashMap<String, Class>();
        }
    }

    public void register(String scheme, T factory) {
        this.components.put(scheme, factory);
    }

    public T unregister(String scheme) {
        if ("default".equals(scheme)) {
            throw new IllegalArgumentException("Cannot uninstall the default " + this.componentType);
        }
        return this.components.remove(scheme);
    }

    public T get(String scheme) {
        T factory = this.components.get(scheme);
        if (factory == null) {
            factory = this.load(scheme);
        }
        return factory;
    }

    private T load(String scheme) {
        Class clazz = this.available.get(scheme);
        if (clazz == null) {
            return null;
        }
        try {
            Object factory = clazz.newInstance();
            this.components.put(scheme, factory);
            return factory;
        }
        catch (Exception e) {
            throw new IllegalStateException(this.componentType + " cannot be installed.  Unable to instantiate the class " + clazz.getName() + " for scheme " + scheme);
        }
    }
}

