/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.client.ClientRuntimeException;

public class ClientInstance {
    private final long startTime = System.currentTimeMillis();
    private final Properties internalProperties = new Properties();
    private final HashMap<Class, Object> components = new HashMap();
    private static ClientInstance client;

    private ClientInstance(Properties properties) throws Exception {
        this.internalProperties.putAll((Map<?, ?>)System.getProperties());
        this.internalProperties.putAll((Map<?, ?>)properties);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Properties getProperties() {
        return this.internalProperties;
    }

    public String getProperty(String key) {
        return this.internalProperties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.internalProperties.getProperty(key, defaultValue);
    }

    public Object setProperty(String key, String value) {
        return this.internalProperties.setProperty(key, value);
    }

    public boolean hasProperty(String propName) {
        return this.internalProperties.get(propName) != null;
    }

    public <T> T getComponent(Class<T> type) {
        return (T)this.components.get(type);
    }

    public <T> T removeComponent(Class<T> type) {
        return (T)this.components.remove(type);
    }

    public <T> T setComponent(Class<T> type, T component) {
        return (T)this.components.put(type, component);
    }

    public static ClientInstance get() {
        return client;
    }

    static {
        try {
            client = new ClientInstance(System.getProperties());
        }
        catch (Exception e) {
            throw new ClientRuntimeException("Failed to create default instance of SystemInstance", e);
        }
    }
}

