/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.openejb.client.CommandParser;
import org.apache.openejb.client.Connection;
import org.apache.openejb.client.ConnectionManager;
import org.apache.openejb.client.MulticastConnectionFactory;
import org.apache.openejb.client.Options;
import sun.net.util.IPAddressUtil;

public class MulticastPulseClient
extends MulticastConnectionFactory {
    private static final String SERVER = "OpenEJB.MCP.Server:";
    private static final String CLIENT = "OpenEJB.MCP.Client:";
    private static final String EMPTY = "NoService";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final int TTL = Integer.parseInt(System.getProperty("org.apache.openejb.multipulse.ttl", "32"));
    private static final Set<URI> badUri = new HashSet<URI>();
    private static final NetworkInterface[] interfaces = MulticastPulseClient.getNetworkInterfaces();
    private static final ExecutorService executor = Executors.newFixedThreadPool(interfaces.length + 1);
    private static final CommandParser cmd = new CommandParser(){

        @Override
        protected void init() {
            this.category("Options");
            this.opt('g', "group").type(String.class).value("*").description("Group name");
            this.opt('h', "host").type(String.class).value("239.255.3.2").description("Multicast address");
            this.opt('p', "port").type(Integer.TYPE).value(6142).description("Multicast port");
            this.opt('t', "timeout").type(Integer.TYPE).value(1000).description("Pulse back timeout");
        }

        @Override
        protected List<String> validate(CommandParser.Arguments arguments) {
            return super.validate(arguments);
        }

        @Override
        protected List<String> usage() {
            return super.usage();
        }
    };

    @Override
    public Connection getConnection(URI uri) throws IOException {
        Set<URI> uriSet;
        Map<String, String> params;
        try {
            params = MulticastConnectionFactory.URIs.parseParamters(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid multicast uri " + uri.toString(), e);
        }
        Set<String> schemes = MulticastPulseClient.getSet(params, "schemes", this.getDefaultSchemes());
        String group = MulticastPulseClient.getString(params, "group", "default");
        long timeout = MulticastPulseClient.getLong(params, "timeout", 250L);
        try {
            uriSet = MulticastPulseClient.discoverURIs(group, schemes, uri.getHost(), uri.getPort(), timeout);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to find an ejb server via the MulticastPulse URI: " + uri);
        }
        for (URI serviceURI : uriSet) {
            if (badUri.contains(serviceURI)) continue;
            try {
                return ConnectionManager.getConnection(URI.create(URI.create(serviceURI.getSchemeSpecificPart()).getSchemeSpecificPart()));
            }
            catch (Throwable e) {
                badUri.add(serviceURI);
            }
        }
        throw new IllegalArgumentException("Unable to connect an ejb server via the MulticastPulse URI: " + uri);
    }

    public static void clearBadUris() {
        badUri.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<URI> discoverURIs(final String forGroup, final Set<String> schemes, String host, int port, long timeout) throws Exception {
        InetAddress ia;
        if (timeout < 50L) {
            timeout = 50L;
        }
        if (null == forGroup || forGroup.isEmpty()) {
            throw new Exception("Specify a valid group or *");
        }
        if (null == schemes || schemes.isEmpty()) {
            throw new Exception("Specify at least one scheme, 'ejbd' for example");
        }
        if (null == host || host.isEmpty()) {
            throw new Exception("Specify a valid host name");
        }
        if (port < 1 || port > 65535) {
            throw new Exception("Specify a valid port between 1 and 65535");
        }
        try {
            ia = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new Exception(host + " is not a valid address", e);
        }
        if (null == ia || !ia.isMulticastAddress()) {
            throw new Exception(host + " is not a valid multicast address");
        }
        byte[] bytes = (CLIENT + forGroup).getBytes(UTF8);
        DatagramPacket request = new DatagramPacket(bytes, bytes.length, new InetSocketAddress(ia, port));
        final AtomicBoolean running = new AtomicBoolean(true);
        final MulticastSocket[] clientSockets = MulticastPulseClient.getSockets(ia, port);
        Timer timer = new Timer(true);
        final TreeSet<URI> set = new TreeSet<URI>(new Comparator<URI>(){

            @Override
            public int compare(URI uri1, URI uri2) {
                URI u1 = URI.create(uri1.getSchemeSpecificPart());
                URI u2 = URI.create(uri2.getSchemeSpecificPart());
                u1 = URI.create(u1.getSchemeSpecificPart());
                u2 = URI.create(u2.getSchemeSpecificPart());
                int i = this.compare(u1.getHost(), u2.getHost());
                if (i == 0) {
                    i = uri1.compareTo(uri2);
                }
                return i;
            }

            @Override
            private int compare(String h1, String h2) {
                try {
                    if (IPAddressUtil.isIPv4LiteralAddress(h1)) {
                        if (IPAddressUtil.isIPv6LiteralAddress(h2.replace("[", "").replace("]", ""))) {
                            return -1;
                        }
                    } else if (IPAddressUtil.isIPv6LiteralAddress(h1.replace("[", "").replace("]", ""))) {
                        if (IPAddressUtil.isIPv4LiteralAddress(h2)) {
                            return 1;
                        }
                    } else if (0 != h1.compareTo(h2)) {
                        return -1;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return h1.compareTo(h2);
            }
        });
        final ReentrantLock setLock = new ReentrantLock();
        final ArrayList futures = new ArrayList();
        final CountDownLatch latch = new CountDownLatch(clientSockets.length);
        for (final MulticastSocket socket : clientSockets) {
            futures.add(executor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    latch.countDown();
                    DatagramPacket response = new DatagramPacket(new byte[2048], 2048);
                    while (running.get()) {
                        try {
                            String s;
                            socket.receive(response);
                            SocketAddress sa = response.getSocketAddress();
                            if (null == sa || !(sa instanceof InetSocketAddress)) continue;
                            int len = response.getLength();
                            if (len > 2048) {
                                len = 2048;
                            }
                            if (!(s = new String(response.getData(), 0, len)).startsWith(MulticastPulseClient.SERVER)) continue;
                            s = s.replace(MulticastPulseClient.SERVER, "");
                            String group = s.substring(0, s.indexOf(58));
                            s = s.substring(group.length() + 1);
                            if (!"*".equals(forGroup) && !forGroup.equals(group)) continue;
                            String services = s.substring(0, s.lastIndexOf(124));
                            s = s.substring(services.length() + 1);
                            String[] serviceList = services.split("\\|");
                            String[] hosts = s.split(",");
                            for (String svc : serviceList) {
                                URI serviceUri;
                                if (MulticastPulseClient.EMPTY.equals(svc)) continue;
                                try {
                                    serviceUri = URI.create(svc);
                                }
                                catch (Throwable e) {
                                    continue;
                                }
                                if (!schemes.contains(serviceUri.getScheme())) continue;
                                String serverHost = ((InetSocketAddress)response.getSocketAddress()).getAddress().getHostAddress();
                                String serviceHost = serviceUri.getHost();
                                if (MulticastPulseClient.isLocalAddress(serviceHost, false) && !MulticastPulseClient.isLocalAddress(serverHost, false)) continue;
                                svc = "mp-" + serverHost + ":" + group + ":" + svc;
                                setLock.lock();
                                try {
                                    if (svc.contains("0.0.0.0")) {
                                        for (String h : hosts) {
                                            if (h.replace("[", "").startsWith("2001:0:")) continue;
                                            set.add(URI.create(svc.replace("0.0.0.0", MulticastPulseClient.ipFormat(h))));
                                        }
                                        continue;
                                    }
                                    if (svc.contains("[::]")) {
                                        for (String h : hosts) {
                                            if (h.replace("[", "").startsWith("2001:0:")) continue;
                                            set.add(URI.create(svc.replace("[::]", MulticastPulseClient.ipFormat(h))));
                                        }
                                        continue;
                                    }
                                    set.add(URI.create(svc));
                                }
                                catch (Throwable e) {
                                }
                                finally {
                                    setLock.unlock();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
            }));
        }
        try {
            if (latch.await(5L, TimeUnit.SECONDS)) {
                for (final MulticastSocket socket : clientSockets) {
                    try {
                        socket.send(request);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            } else {
                timeout = 1L;
            }
        }
        catch (InterruptedException e) {
            timeout = 1L;
        }
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                running.set(false);
                for (Future future : futures) {
                    future.cancel(true);
                }
                for (MulticastSocket socket : clientSockets) {
                    try {
                        socket.leaveGroup(ia);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    try {
                        socket.close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        }, timeout);
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Throwable e) {}
        }
        setLock.lock();
        try {
            TreeSet<URI> treeSet = new TreeSet<URI>((Collection<URI>)set);
            return treeSet;
        }
        finally {
            setLock.unlock();
        }
    }

    public static boolean isLocalAddress(String host, boolean wildcardIsLocal) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            return false;
        }
        if (wildcardIsLocal && addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    private static String ipFormat(String h) throws UnknownHostException {
        InetAddress ia = InetAddress.getByName(h);
        if (ia instanceof Inet6Address) {
            return "[" + ia.getHostAddress() + "]";
        }
        return h;
    }

    public static MulticastSocket[] getSockets(InetAddress ia, int port) throws Exception {
        ArrayList<MulticastSocket> list = new ArrayList<MulticastSocket>();
        for (NetworkInterface ni : interfaces) {
            MulticastSocket ms = null;
            try {
                ms = new MulticastSocket(port);
                ms.setNetworkInterface(ni);
                ms.setSoTimeout(0);
                ms.setTimeToLive(TTL);
                if (!ms.getBroadcast()) {
                    ms.setBroadcast(true);
                }
                ms.joinGroup(ia);
                list.add(ms);
            }
            catch (Throwable e) {
                if (null == ms) continue;
                try {
                    ms.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        return list.toArray(new MulticastSocket[list.size()]);
    }

    private static NetworkInterface[] getNetworkInterfaces() {
        HashSet<NetworkInterface> list = new HashSet<NetworkInterface>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface next = interfaces.nextElement();
                if (!next.supportsMulticast() || !next.isUp()) continue;
                list.add(next);
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return list.toArray(new NetworkInterface[list.size()]);
    }

    public static void main(String[] args) throws Exception {
        CommandParser.Arguments arguments;
        try {
            arguments = cmd.parse(args);
        }
        catch (CommandParser.HelpException e) {
            System.exit(0);
            throw new Exception();
        }
        catch (CommandParser.InvalidOptionsException e) {
            System.exit(1);
            throw new Exception();
        }
        Options options = arguments.options();
        final String discover = options.get("group", "*");
        final String mchost = options.get("host", "239.255.3.2");
        final int mcport = options.get("port", 6142);
        final int timeout = options.get("timeout", 1500);
        final AtomicBoolean running = new AtomicBoolean(true);
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (running.get()) {
                    Set<URI> uriSet = null;
                    try {
                        uriSet = MulticastPulseClient.discoverURIs(discover, new HashSet<String>(Arrays.asList("ejbd", "ejbds", "http", "https")), mchost, mcport, timeout);
                    }
                    catch (Throwable e) {
                        System.err.println(e.getMessage());
                    }
                    if (uriSet != null && uriSet.size() > 0) {
                        for (URI uri : uriSet) {
                            String server = uri.getScheme().replace("mp-", "");
                            uri = URI.create(uri.getSchemeSpecificPart());
                            String group = uri.getScheme();
                            uri = URI.create(uri.getSchemeSpecificPart());
                            String host = uri.getHost();
                            int port = uri.getPort();
                            if (MulticastPulseClient.isLocalAddress(host, false) && !MulticastPulseClient.isLocalAddress(server, false)) {
                                System.out.println(server + ":" + group + " - " + uri.toASCIIString() + " is not a local service");
                                continue;
                            }
                            boolean b = false;
                            Socket s = new Socket();
                            try {
                                s.connect(new InetSocketAddress(host, port), 500);
                                b = true;
                            }
                            catch (Throwable e) {
                            }
                            finally {
                                try {
                                    s.close();
                                }
                                catch (Throwable e) {}
                            }
                            System.out.println(server + ":" + group + " - " + uri.toASCIIString() + " is reachable: " + b);
                        }
                    } else {
                        System.out.println("### Failed to discover server: " + discover);
                    }
                    System.out.println(".");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, "MulticastPulseClient Test");
        t.setDaemon(true);
        t.start();
        System.in.read();
        running.set(false);
        t.interrupt();
    }
}

