/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.DefaultedThreadLocal;
import org.apache.openejb.client.EJBHomeHandler;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.ServerMetaData;

public class EJBHomeProxyHandle
implements Externalizable {
    private static final long serialVersionUID = 1523695567435111622L;
    public static final ThreadLocal<Resolver> resolver = new DefaultedThreadLocal<ClientSideResovler>(new ClientSideResovler());
    private transient EJBHomeHandler handler;
    private transient ProtocolMetaData metaData;

    public EJBHomeProxyHandle() {
    }

    public EJBHomeProxyHandle(EJBHomeHandler handler) {
        this.handler = handler;
    }

    public void setMetaData(ProtocolMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        this.handler.client.setMetaData(this.metaData);
        this.handler.client.writeExternal(out);
        EJBMetaDataImpl ejb = this.handler.ejb;
        out.writeObject(ejb.homeClass);
        out.writeObject(ejb.remoteClass);
        out.writeObject(ejb.keyClass);
        out.writeByte(ejb.type);
        out.writeUTF(ejb.deploymentID);
        out.writeShort(ejb.deploymentCode);
        this.handler.server.setMetaData(this.metaData);
        this.handler.server.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        ClientMetaData client = new ClientMetaData();
        EJBMetaDataImpl ejb = new EJBMetaDataImpl();
        ServerMetaData server = new ServerMetaData();
        client.setMetaData(this.metaData);
        client.readExternal(in);
        ejb.homeClass = (Class)in.readObject();
        ejb.remoteClass = (Class)in.readObject();
        ejb.keyClass = (Class)in.readObject();
        ejb.type = in.readByte();
        ejb.deploymentID = in.readUTF();
        ejb.deploymentCode = in.readShort();
        server.setMetaData(this.metaData);
        server.readExternal(in);
        this.handler = EJBHomeHandler.createEJBHomeHandler(ejb, server, client, null);
    }

    private Object readResolve() throws ObjectStreamException {
        return resolver.get().resolve(this.handler);
    }

    public static class ClientSideResovler
    implements Resolver {
        @Override
        public Object resolve(EJBHomeHandler handler) {
            handler.ejb.ejbHomeProxy = handler.createEJBHomeProxy();
            return handler.ejb.ejbHomeProxy;
        }
    }

    public static interface Resolver {
        public Object resolve(EJBHomeHandler var1);
    }
}

