/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cli.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.openejb.AppContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.cli.command.Command;
import org.apache.openejb.server.cli.command.PathCommand;
import org.apache.openejb.spi.ContainerSystem;

@Command(name="apps", usage="apps", description="list deployed applications")
public class DeployedAppCommand
extends PathCommand {
    @Override
    public void execute(String cmd) {
        this.streamManager.writeOut("Deployed applications:");
        ArrayList apps = new ArrayList(((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getAppContexts());
        Collections.sort(apps, new AppContextComparable());
        for (AppContext appContext : apps) {
            this.streamManager.writeOut("  - " + appContext.getId());
        }
    }

    private class AppContextComparable
    implements Comparator<AppContext> {
        private AppContextComparable() {
        }

        @Override
        public int compare(AppContext o1, AppContext o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }
}

