/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.openejb.jee.AroundInvoke;
import org.apache.openejb.jee.ConcurrencyType;
import org.apache.openejb.jee.EjbLocalRef;
import org.apache.openejb.jee.EjbRef;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EnvEntry;
import org.apache.openejb.jee.Icon;
import org.apache.openejb.jee.InitMethod;
import org.apache.openejb.jee.KeyedCollection;
import org.apache.openejb.jee.LifecycleCallback;
import org.apache.openejb.jee.LocalCollection;
import org.apache.openejb.jee.MessageDestinationRef;
import org.apache.openejb.jee.NamedMethod;
import org.apache.openejb.jee.PersistenceContextRef;
import org.apache.openejb.jee.PersistenceUnitRef;
import org.apache.openejb.jee.RemoteBean;
import org.apache.openejb.jee.RemoveMethod;
import org.apache.openejb.jee.ResourceEnvRef;
import org.apache.openejb.jee.ResourceRef;
import org.apache.openejb.jee.SecurityIdentity;
import org.apache.openejb.jee.SecurityRoleRef;
import org.apache.openejb.jee.ServiceRef;
import org.apache.openejb.jee.Session;
import org.apache.openejb.jee.SessionType;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;
import org.apache.openejb.jee.TimerConsumer;
import org.apache.openejb.jee.TransactionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="session-beanType", propOrder={"descriptions", "displayNames", "icon", "ejbName", "mappedName", "home", "remote", "localHome", "local", "businessLocal", "businessRemote", "serviceEndpoint", "ejbClass", "sessionType", "loadOnStartup", "timeoutMethod", "initMethod", "removeMethod", "transactionType", "concurrencyType", "aroundInvoke", "envEntry", "ejbRef", "ejbLocalRef", "serviceRef", "resourceRef", "resourceEnvRef", "messageDestinationRef", "persistenceContextRef", "persistenceUnitRef", "postConstruct", "preDestroy", "postActivate", "prePassivate", "securityRoleRef", "securityIdentity", "dependsOn"})
public class SessionBean
implements EnterpriseBean,
RemoteBean,
Session,
TimerConsumer {
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlTransient
    protected TextMap displayName = new TextMap();
    @XmlElement(name="icon", required=true)
    protected LocalCollection<Icon> icon = new LocalCollection();
    @XmlElement(name="ejb-name", required=true)
    protected String ejbName;
    @XmlElement(name="mapped-name")
    protected String mappedName;
    protected String home;
    protected String remote;
    @XmlElement(name="local-home")
    protected String localHome;
    protected String local;
    @XmlElement(name="business-local")
    protected LinkedHashSet<String> businessLocal;
    @XmlElement(name="business-remote")
    protected LinkedHashSet<String> businessRemote;
    @XmlElement(name="service-endpoint")
    protected String serviceEndpoint;
    @XmlElement(name="ejb-class")
    protected String ejbClass;
    @XmlElement(name="session-type")
    protected SessionType sessionType = SessionType.STATELESS;
    @XmlElement(name="timeout-method")
    protected NamedMethod timeoutMethod;
    @XmlElement(name="init-method", required=true)
    protected List<InitMethod> initMethod;
    @XmlElement(name="remove-method", required=true)
    protected List<RemoveMethod> removeMethod;
    @XmlElement(name="transaction-type")
    protected TransactionType transactionType;
    @XmlElement(name="concurrency-type")
    protected ConcurrencyType concurrencyType;
    @XmlElement(name="around-invoke", required=true)
    protected List<AroundInvoke> aroundInvoke;
    @XmlElement(name="env-entry", required=true)
    protected KeyedCollection<String, EnvEntry> envEntry;
    @XmlElement(name="ejb-ref", required=true)
    protected KeyedCollection<String, EjbRef> ejbRef;
    @XmlElement(name="ejb-local-ref", required=true)
    protected KeyedCollection<String, EjbLocalRef> ejbLocalRef;
    @XmlElement(name="service-ref", required=true)
    protected KeyedCollection<String, ServiceRef> serviceRef;
    @XmlElement(name="resource-ref", required=true)
    protected KeyedCollection<String, ResourceRef> resourceRef;
    @XmlElement(name="resource-env-ref", required=true)
    protected KeyedCollection<String, ResourceEnvRef> resourceEnvRef;
    @XmlElement(name="message-destination-ref", required=true)
    protected KeyedCollection<String, MessageDestinationRef> messageDestinationRef;
    @XmlElement(name="persistence-context-ref", required=true)
    protected KeyedCollection<String, PersistenceContextRef> persistenceContextRef;
    @XmlElement(name="persistence-unit-ref", required=true)
    protected KeyedCollection<String, PersistenceUnitRef> persistenceUnitRef;
    @XmlElement(name="post-construct", required=true)
    protected List<LifecycleCallback> postConstruct;
    @XmlElement(name="pre-destroy", required=true)
    protected List<LifecycleCallback> preDestroy;
    @XmlElement(name="post-activate", required=true)
    protected List<LifecycleCallback> postActivate;
    @XmlElement(name="pre-passivate", required=true)
    protected List<LifecycleCallback> prePassivate;
    @XmlElement(name="security-role-ref", required=true)
    protected List<SecurityRoleRef> securityRoleRef;
    @XmlElement(name="security-identity")
    protected SecurityIdentity securityIdentity;
    @XmlElement(name="load-on-startup")
    protected Boolean loadOnStartup;
    @XmlElementWrapper(name="depends-on")
    @XmlElement(name="ejb-name")
    protected List<String> dependsOn;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    public SessionBean() {
    }

    public SessionBean(String ejbName, String ejbClass, SessionType sessionType) {
        this.ejbName = ejbName;
        this.ejbClass = ejbClass;
        this.sessionType = sessionType;
    }

    @Override
    public String getJndiConsumerName() {
        return this.ejbName;
    }

    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    @XmlElement(name="display-name", required=true)
    public Text[] getDisplayNames() {
        return this.displayName.toArray();
    }

    public void setDisplayNames(Text[] text) {
        this.displayName.set(text);
    }

    public String getDisplayName() {
        return this.displayName.get();
    }

    public Collection<Icon> getIcons() {
        if (this.icon == null) {
            this.icon = new LocalCollection();
        }
        return this.icon;
    }

    public Map<String, Icon> getIconMap() {
        if (this.icon == null) {
            this.icon = new LocalCollection();
        }
        return this.icon.toMap();
    }

    public Icon getIcon() {
        return this.icon.getLocal();
    }

    @Override
    public String getEjbName() {
        return this.ejbName;
    }

    @Override
    public void setEjbName(String value) {
        this.ejbName = value;
    }

    @Override
    public String getMappedName() {
        return this.mappedName;
    }

    @Override
    public void setMappedName(String value) {
        this.mappedName = value;
    }

    @Override
    public String getHome() {
        return this.home;
    }

    @Override
    public void setHome(String value) {
        this.home = value;
    }

    @Override
    public String getRemote() {
        return this.remote;
    }

    @Override
    public void setRemote(String value) {
        this.remote = value;
    }

    public void setHomeAndRemote(String home, String remote) {
        this.remote = remote;
        this.home = home;
    }

    public void setHomeAndRemote(Class<?> home, Class<?> remote) {
        this.remote = remote.getName();
        this.home = home.getName();
    }

    public void setHomeAndLocal(String localHome, String local) {
        this.local = local;
        this.localHome = localHome;
    }

    public void setHomeAndLocal(Class<?> localHome, Class<?> local) {
        this.local = local.getName();
        this.localHome = localHome.getName();
    }

    @Override
    public String getLocalHome() {
        return this.localHome;
    }

    @Override
    public void setLocalHome(String value) {
        this.localHome = value;
    }

    @Override
    public String getLocal() {
        return this.local;
    }

    @Override
    public void setLocal(String value) {
        this.local = value;
    }

    @Override
    public Collection<String> getBusinessLocal() {
        if (this.businessLocal == null) {
            this.businessLocal = new LinkedHashSet();
        }
        return this.businessLocal;
    }

    public void addBusinessLocal(String businessLocal) {
        if (businessLocal == null) {
            return;
        }
        this.getBusinessLocal().add(businessLocal);
    }

    public void addBusinessLocal(Class businessLocal) {
        this.addBusinessLocal(businessLocal.getName());
    }

    @Override
    public Collection<String> getBusinessRemote() {
        if (this.businessRemote == null) {
            this.businessRemote = new LinkedHashSet();
        }
        return this.businessRemote;
    }

    public void addBusinessRemote(String businessRemote) {
        if (businessRemote == null) {
            return;
        }
        this.getBusinessRemote().add(businessRemote);
    }

    public void addBusinessRemote(Class businessRemote) {
        this.addBusinessRemote(businessRemote.getName());
    }

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public void setServiceEndpoint(String value) {
        this.serviceEndpoint = value;
    }

    @Override
    public String getEjbClass() {
        return this.ejbClass;
    }

    @Override
    public void setEjbClass(String value) {
        this.ejbClass = value;
    }

    public SessionType getSessionType() {
        return this.sessionType;
    }

    public void setSessionType(SessionType value) {
        this.sessionType = value;
    }

    @Override
    public NamedMethod getTimeoutMethod() {
        return this.timeoutMethod;
    }

    @Override
    public void setTimeoutMethod(NamedMethod value) {
        this.timeoutMethod = value;
    }

    @Override
    public List<InitMethod> getInitMethod() {
        if (this.initMethod == null) {
            this.initMethod = new ArrayList<InitMethod>();
        }
        return this.initMethod;
    }

    @Override
    public List<RemoveMethod> getRemoveMethod() {
        if (this.removeMethod == null) {
            this.removeMethod = new ArrayList<RemoveMethod>();
        }
        return this.removeMethod;
    }

    @Override
    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public ConcurrencyType getConcurrencyType() {
        return this.concurrencyType;
    }

    @Override
    public void setTransactionType(TransactionType value) {
        this.transactionType = value;
    }

    public void setConcurrencyType(ConcurrencyType value) {
        this.concurrencyType = value;
    }

    @Override
    public List<AroundInvoke> getAroundInvoke() {
        if (this.aroundInvoke == null) {
            this.aroundInvoke = new ArrayList<AroundInvoke>();
        }
        return this.aroundInvoke;
    }

    @Override
    public void addAroundInvoke(String method) {
        assert (this.ejbClass != null) : "Set the ejbClass before calling this method";
        this.getAroundInvoke().add(new AroundInvoke(this.ejbClass, method));
    }

    @Override
    public Collection<EnvEntry> getEnvEntry() {
        if (this.envEntry == null) {
            this.envEntry = new KeyedCollection();
        }
        return this.envEntry;
    }

    @Override
    public Map<String, EnvEntry> getEnvEntryMap() {
        if (this.envEntry == null) {
            this.envEntry = new KeyedCollection();
        }
        return this.envEntry.toMap();
    }

    @Override
    public Collection<EjbRef> getEjbRef() {
        if (this.ejbRef == null) {
            this.ejbRef = new KeyedCollection();
        }
        return this.ejbRef;
    }

    @Override
    public Map<String, EjbRef> getEjbRefMap() {
        if (this.ejbRef == null) {
            this.ejbRef = new KeyedCollection();
        }
        return this.ejbRef.toMap();
    }

    @Override
    public Collection<EjbLocalRef> getEjbLocalRef() {
        if (this.ejbLocalRef == null) {
            this.ejbLocalRef = new KeyedCollection();
        }
        return this.ejbLocalRef;
    }

    @Override
    public Map<String, EjbLocalRef> getEjbLocalRefMap() {
        if (this.ejbLocalRef == null) {
            this.ejbLocalRef = new KeyedCollection();
        }
        return this.ejbLocalRef.toMap();
    }

    @Override
    public Collection<ServiceRef> getServiceRef() {
        if (this.serviceRef == null) {
            this.serviceRef = new KeyedCollection();
        }
        return this.serviceRef;
    }

    @Override
    public Map<String, ServiceRef> getServiceRefMap() {
        if (this.serviceRef == null) {
            this.serviceRef = new KeyedCollection();
        }
        return this.serviceRef.toMap();
    }

    @Override
    public Collection<ResourceRef> getResourceRef() {
        if (this.resourceRef == null) {
            this.resourceRef = new KeyedCollection();
        }
        return this.resourceRef;
    }

    @Override
    public Map<String, ResourceRef> getResourceRefMap() {
        if (this.resourceRef == null) {
            this.resourceRef = new KeyedCollection();
        }
        return this.resourceRef.toMap();
    }

    @Override
    public Collection<ResourceEnvRef> getResourceEnvRef() {
        if (this.resourceEnvRef == null) {
            this.resourceEnvRef = new KeyedCollection();
        }
        return this.resourceEnvRef;
    }

    @Override
    public Map<String, ResourceEnvRef> getResourceEnvRefMap() {
        if (this.resourceEnvRef == null) {
            this.resourceEnvRef = new KeyedCollection();
        }
        return this.resourceEnvRef.toMap();
    }

    @Override
    public Collection<MessageDestinationRef> getMessageDestinationRef() {
        if (this.messageDestinationRef == null) {
            this.messageDestinationRef = new KeyedCollection();
        }
        return this.messageDestinationRef;
    }

    @Override
    public Map<String, MessageDestinationRef> getMessageDestinationRefMap() {
        if (this.messageDestinationRef == null) {
            this.messageDestinationRef = new KeyedCollection();
        }
        return this.messageDestinationRef.toMap();
    }

    @Override
    public Collection<PersistenceContextRef> getPersistenceContextRef() {
        if (this.persistenceContextRef == null) {
            this.persistenceContextRef = new KeyedCollection();
        }
        return this.persistenceContextRef;
    }

    @Override
    public Map<String, PersistenceContextRef> getPersistenceContextRefMap() {
        if (this.persistenceContextRef == null) {
            this.persistenceContextRef = new KeyedCollection();
        }
        return this.persistenceContextRef.toMap();
    }

    @Override
    public Collection<PersistenceUnitRef> getPersistenceUnitRef() {
        if (this.persistenceUnitRef == null) {
            this.persistenceUnitRef = new KeyedCollection();
        }
        return this.persistenceUnitRef;
    }

    @Override
    public Map<String, PersistenceUnitRef> getPersistenceUnitRefMap() {
        if (this.persistenceUnitRef == null) {
            this.persistenceUnitRef = new KeyedCollection();
        }
        return this.persistenceUnitRef.toMap();
    }

    @Override
    public List<LifecycleCallback> getPostConstruct() {
        if (this.postConstruct == null) {
            this.postConstruct = new ArrayList<LifecycleCallback>();
        }
        return this.postConstruct;
    }

    @Override
    public void addPostConstruct(String method) {
        assert (this.ejbClass != null) : "Set the ejbClass before calling this method";
        this.getPostConstruct().add(new LifecycleCallback(this.ejbClass, method));
    }

    @Override
    public List<LifecycleCallback> getPreDestroy() {
        if (this.preDestroy == null) {
            this.preDestroy = new ArrayList<LifecycleCallback>();
        }
        return this.preDestroy;
    }

    @Override
    public void addPreDestroy(String method) {
        assert (this.ejbClass != null) : "Set the ejbClass before calling this method";
        this.getPreDestroy().add(new LifecycleCallback(this.ejbClass, method));
    }

    @Override
    public List<LifecycleCallback> getPostActivate() {
        if (this.postActivate == null) {
            this.postActivate = new ArrayList<LifecycleCallback>();
        }
        return this.postActivate;
    }

    @Override
    public void addPostActivate(String method) {
        assert (this.ejbClass != null) : "Set the ejbClass before calling this method";
        this.getPostActivate().add(new LifecycleCallback(this.ejbClass, method));
    }

    @Override
    public List<LifecycleCallback> getPrePassivate() {
        if (this.prePassivate == null) {
            this.prePassivate = new ArrayList<LifecycleCallback>();
        }
        return this.prePassivate;
    }

    @Override
    public void addPrePassivate(String method) {
        assert (this.ejbClass != null) : "Set the ejbClass before calling this method";
        this.getPrePassivate().add(new LifecycleCallback(this.ejbClass, method));
    }

    @Override
    public List<SecurityRoleRef> getSecurityRoleRef() {
        if (this.securityRoleRef == null) {
            this.securityRoleRef = new ArrayList<SecurityRoleRef>();
        }
        return this.securityRoleRef;
    }

    @Override
    public SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }

    @Override
    public void setSecurityIdentity(SecurityIdentity value) {
        this.securityIdentity = value;
    }

    public List<String> getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String ... ejbNames) {
        this.setDependsOn(Arrays.asList(ejbNames));
    }

    public void setDependsOn(List<String> ejbNames) {
        this.dependsOn = new ArrayList<String>(ejbNames);
    }

    public boolean hasLoadOnStartup() {
        return this.loadOnStartup != null;
    }

    public boolean getLoadOnStartup() {
        return this.loadOnStartup != null && this.loadOnStartup != false;
    }

    public void setLoadOnStartup(boolean loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        this.id = value;
    }
}

