/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.openejb.junit;

import org.apache.openejb.testing.ApplicationComposers;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ApplicationComposerRule implements TestRule {
    private final Object instance;
    private final Object[] modules;

    public ApplicationComposerRule(final Object instance, final Object... modules) {
        this.instance = instance;
        if (modules == null) {
            this.modules = new Object[0];
        } else {
            this.modules = modules;
        }
    }

    @Override
    public Statement apply(final Statement base, final Description description) {
        return new DeployApplication(instance, base, new ApplicationComposers(instance.getClass(), modules));
    }
}
