/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.openejb.loader.ClassPath;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.SystemInstance;

public class Embedder {
    public static final String ADDITIONAL_LIB_FOLDER = SystemInstance.get().getOptions().get("openejb.additional.lib.folder", "additionallib");
    private final String className;
    private Class loaderClass;
    private String NO_HOME = "The openejb.home is not set.";
    private String BAD_HOME = "Invalid openejb.home: ";
    private String NOT_THERE = "The path specified does not exist.";
    private String NOT_DIRECTORY = "The path specified is not a directory.";
    private String NO_LIBS = "The path specified is not correct, it does not contain any OpenEJB libraries.";
    private String INSTRUCTIONS = "Please edit the web.xml of the openejb_loader webapp and set the openejb.home init-param to the full path where OpenEJB is installed.";

    public Embedder(String className) {
        this.className = className;
    }

    public Class load() throws Exception {
        if (this.loaderClass == null) {
            ClassPath classPath = SystemInstance.get().getClassPath();
            ClassLoader classLoader = classPath.getClassLoader();
            try {
                this.loaderClass = classLoader.loadClass(this.className);
            }
            catch (Exception e) {
                this.loaderClass = this.forcefulLoad(classPath, classLoader);
            }
        }
        return this.loaderClass;
    }

    public Object init(Properties properties) throws Exception {
        Class loaderClass = this.load();
        try {
            Method init = loaderClass.getMethod("init", Properties.class);
            Object instance = loaderClass.newInstance();
            Object value = init.invoke(instance, properties);
            return value;
        }
        catch (NoSuchMethodException e) {
            throw (IllegalStateException)new IllegalStateException("Signatures for Loader are no longer correct.").initCause(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw (Exception)cause;
        }
    }

    private Class forcefulLoad(ClassPath classPath, ClassLoader classLoader) throws Exception {
        try {
            File libsDir;
            String libsPath = SystemInstance.get().getProperty("openejb.libs");
            if (libsPath != null) {
                libsDir = new File(libsPath);
            } else {
                this.checkOpenEjbHome(SystemInstance.get().getHome().getDirectory());
                FileUtils home = SystemInstance.get().getHome();
                libsDir = home.getDirectory("lib");
            }
            classPath.addJarsToPath(libsDir);
        }
        catch (Exception e2) {
            throw new Exception("Could not load OpenEJB libraries. Exception: " + e2.getClass().getName() + " " + e2.getMessage());
        }
        try {
            File additionalLib = SystemInstance.get().getBase().getDirectory(ADDITIONAL_LIB_FOLDER);
            if (additionalLib.exists()) {
                classPath.addJarsToPath(additionalLib);
            }
        }
        catch (Exception e2) {
            throw new Exception("Could not load OpenEJB libraries. Exception: " + e2.getClass().getName() + " " + e2.getMessage());
        }
        try {
            return classLoader.loadClass(this.className);
        }
        catch (LinkageError le) {
            try {
                return classLoader.loadClass(this.className);
            }
            catch (Exception rethrow) {
                throw new Exception("Could not load class '" + this.className + "' after embedding libraries. Exception: " + le.getClass().getName() + " " + le.getMessage());
            }
        }
        catch (Exception e2) {
            throw new Exception("Could not load class '" + this.className + "' after embedding libraries. Exception: " + e2.getClass().getName() + " " + e2.getMessage());
        }
    }

    private void checkOpenEjbHome(File openejbHome) throws Exception {
        try {
            File openejbHomeLibs;
            String homePath = openejbHome.getAbsolutePath();
            if (!openejbHome.exists()) {
                this.handleError(this.BAD_HOME + homePath, this.NOT_THERE, this.INSTRUCTIONS);
            }
            if (!openejbHome.isDirectory()) {
                this.handleError(this.BAD_HOME + homePath, this.NOT_DIRECTORY, this.INSTRUCTIONS);
            }
            if (!(openejbHomeLibs = new File(openejbHome, "lib")).exists()) {
                this.handleError(this.BAD_HOME + homePath, this.NO_LIBS, this.INSTRUCTIONS);
            }
            String[] libs = openejbHomeLibs.list();
            boolean found = false;
            for (int i = 0; i < libs.length && !found; ++i) {
                found = libs[i].startsWith("openejb-") && libs[i].endsWith(".jar");
            }
            if (!found) {
                this.handleError(this.BAD_HOME + homePath, this.NO_LIBS, this.INSTRUCTIONS);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleError(String m1, String m2, String m3) throws Exception {
        System.err.println("--[PLEASE FIX]-------------------------------------");
        System.err.println(m1);
        System.err.println(m2);
        System.err.println(m3);
        System.err.println("---------------------------------------------------");
        throw new Exception(m1 + " " + m2 + " " + m3);
    }

    private void handleError(String m1, String m2) throws Exception {
        System.err.println("--[PLEASE FIX]-------------------------------------");
        System.err.println(m1);
        System.err.println(m2);
        System.err.println("---------------------------------------------------");
        throw new Exception(m1 + " " + m2);
    }
}

