/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.installer;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.tomee.installer.Alerts;
import org.apache.tomee.installer.Installers;
import org.apache.tomee.installer.Paths;

public class Installer {
    private final Alerts alerts = new Alerts();
    private static final boolean listenerInstalled = "OpenEJBListener".equals(SystemInstance.get().getOptions().get("openejb.embedder.source", "")) || "ServerListener".equals(SystemInstance.get().getOptions().get("openejb.embedder.source", ""));
    private static final boolean agentInstalled = Installer.invokeStaticNoArgMethod("org.apache.openejb.javaagent.Agent", "getInstrumentation") != null;
    private boolean force = false;
    private final Paths paths;
    private Status status = Status.NONE;

    public static boolean isListenerInstalled() {
        return listenerInstalled;
    }

    public static boolean isAgentInstalled() {
        return agentInstalled;
    }

    public Installer(Paths paths) {
        this.paths = paths;
        if (listenerInstalled && agentInstalled) {
            this.status = Status.INSTALLED;
        }
    }

    public Installer(Paths paths, boolean force) {
        this(paths);
        this.force = force;
    }

    public Alerts getAlerts() {
        return this.alerts;
    }

    public void reset() {
        this.alerts.reset();
    }

    public Status getStatus() {
        return this.status;
    }

    public void installAll() {
        this.installListener();
        this.installJavaagent();
        this.installConfigFiles();
        this.removeTomcatLibJar("annotations-api.jar");
        this.removeTomcatLibJar("el-api.jar");
        this.addJavaeeInEndorsed();
        this.addTomEEAdminConfInTomcatUsers();
        this.addTomEELinkToTomcatHome();
        if (!this.alerts.hasErrors()) {
            this.status = Status.REBOOT_REQUIRED;
        }
    }

    public void addTomEEAdminConfInTomcatUsers() {
        this.addTomEEAdminConfInTomcatUsers(false);
    }

    public void addTomEEAdminConfInTomcatUsers(boolean securityActivated) {
        String tomcatUsersXml = Installers.readAll(this.paths.getTomcatUsersXml(), this.alerts);
        if (tomcatUsersXml == null) {
            return;
        }
        if (tomcatUsersXml.contains("tomee-admin")) {
            this.alerts.addWarning("Can't add tomee user to tomcat-users.xml");
            return;
        }
        if (!Installers.backup(this.paths.getTomcatUsersXml(), this.alerts)) {
            return;
        }
        String roleUserTags = "  <role rolename=\"tomee-admin\" />\n  <user username=\"tomee\" password=\"tomee\" roles=\"tomee-admin,manager-gui\" />\n";
        String content = null;
        content = !securityActivated ? "  <!-- Activate those lines to get access to TomEE GUI -->\n  <!--\n  <role rolename=\"tomee-admin\" />\n  <user username=\"tomee\" password=\"tomee\" roles=\"tomee-admin,manager-gui\" />\n  -->\n</tomcat-users>\n" : "  <!-- Activate those lines to get access to TomEE GUI\n -->  <role rolename=\"tomee-admin\" />\n  <user username=\"tomee\" password=\"tomee\" roles=\"tomee-admin,manager-gui\" />\n</tomcat-users>\n";
        String newTomcatUsers = tomcatUsersXml.replace("</tomcat-users>", content);
        if (Installers.writeAll(this.paths.getTomcatUsersXml(), newTomcatUsers, this.alerts)) {
            this.alerts.addInfo("Add tomee user to tomcat-users.xml");
        }
    }

    public void installFull() {
        this.installListener("org.apache.tomee.catalina.ServerListener");
        this.installJavaagent();
        this.installConfigFiles();
        this.removeTomcatLibJar("annotations-api.jar");
        this.removeTomcatLibJar("el-api.jar");
        this.addJavaeeInEndorsed();
        this.moveLibs();
        this.addTomEEAdminConfInTomcatUsers();
        this.addTomEELinkToTomcatHome();
        this.commentDeploymentDir();
        if (!this.alerts.hasErrors()) {
            this.status = Status.REBOOT_REQUIRED;
        }
    }

    private void commentDeploymentDir() {
        File tomeeXml = new File(this.paths.getCatalinaConfDir(), "tomee.xml");
        if (!tomeeXml.exists()) {
            Installers.writeAll(tomeeXml, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<tomee>\n  <!-- see http://tomee.apache.org/containers-and-resources.html -->\n</tomee\n", this.alerts);
        }
    }

    private void addTomEELinkToTomcatHome() {
        File home = this.paths.getHome();
        String indeJsp = Installers.readAll(home, this.alerts);
        if (indeJsp == null) {
            return;
        }
        if (!indeJsp.contains("tomcat7Url")) {
            this.alerts.addWarning("webapps/ROOT/index.jsp was modified");
            return;
        }
        String newIndeJsp = indeJsp.replaceFirst("<div id=\"actions\">", "<div id=\\\"actions\\\">\r\n                    <div class=\"button\">\n                        <a class=\"container shadow\" href=\"/tomee\"><span>TomEE Gui</span></a>\n                    </div>");
        Installers.writeAll(home, newIndeJsp, this.alerts);
    }

    private void moveLibs() {
        File libs = this.paths.getCatalinaLibDir();
        File[] files = this.paths.getOpenEJBLibDir().listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory() || !file.getName().endsWith(".jar")) continue;
                try {
                    Installers.copyFile(file, new File(libs, file.getName()));
                    if (!file.delete()) {
                        file.deleteOnExit();
                    }
                    this.alerts.addInfo("Copy " + file.getName() + " to lib");
                }
                catch (IOException e) {
                    this.alerts.addError("Unable to " + file.getName() + " to Tomcat lib directory.  This will need to be performed manually.", e);
                }
            }
        }
    }

    private void addJavaeeInEndorsed() {
        File endorsed = new File(this.paths.getCatalinaHomeDir(), "endorsed");
        if (!endorsed.mkdir()) {
            this.alerts.addWarning("can't create endorsed directory");
        }
        this.copyClasses(this.paths.getJavaEEAPIJar(), new File(endorsed, "annotation-api.jar"), "javax/annotation/.*");
        this.copyClasses(this.paths.getJavaEEAPIJar(), new File(endorsed, "jaxb-api.jar"), "javax/xml/bind/.*");
        File jaxbImpl = new File(endorsed, "jaxb-impl.jar");
        if (!jaxbImpl.exists()) {
            try {
                Installers.copyFile(this.paths.getJAXBImpl(), jaxbImpl);
            }
            catch (IOException e) {
                this.alerts.addError("can't copy " + this.paths.getJAXBImpl().getPath() + " to " + endorsed.getPath() + "/jaxb-impl.jar");
            }
        }
    }

    private void copyClasses(File sourceJar, File destinationJar, String pattern) {
        if (sourceJar == null) {
            throw new NullPointerException("sourceJar");
        }
        if (destinationJar == null) {
            throw new NullPointerException("destinationJar");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        if (destinationJar.exists()) {
            return;
        }
        try {
            ZipEntry entry;
            ZipInputStream source = new ZipInputStream(IO.read((File)sourceJar));
            ByteArrayOutputStream destinationBuffer = new ByteArrayOutputStream(524288);
            ZipOutputStream destination = new ZipOutputStream(destinationBuffer);
            while ((entry = source.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (!entryName.matches(pattern)) continue;
                destination.putNextEntry(new ZipEntry(entryName));
                IO.copy((InputStream)source, (OutputStream)destination);
            }
            IO.close((Closeable)source);
            IO.close((Closeable)destination);
            IO.copy((byte[])destinationBuffer.toByteArray(), (File)destinationJar);
        }
        catch (IOException e) {
            this.alerts.addError(e.getMessage());
        }
    }

    private void removeTomcatLibJar(String name) {
        File annotationApi = new File(this.paths.getCatalinaLibDir(), name);
        if (annotationApi.exists()) {
            if (!annotationApi.delete()) {
                annotationApi.deleteOnExit();
            }
            this.alerts.addInfo("Please restart the server or delete manually " + name);
        }
    }

    public void installListener() {
        this.installListener("org.apache.tomee.loader.OpenEJBListener");
    }

    public void installListener(String listener) {
        String serverXmlOriginal;
        if (listenerInstalled && !this.force) {
            return;
        }
        boolean copyOpenEJBLoader = true;
        File destination = new File(this.paths.getCatalinaLibDir(), this.paths.getOpenEJBTomcatLoaderJar().getName());
        if (destination.exists() && this.paths.getOpenEJBTomcatLoaderJar().length() == destination.length()) {
            copyOpenEJBLoader = false;
        }
        if (copyOpenEJBLoader) {
            try {
                Installers.copyFile(this.paths.getOpenEJBTomcatLoaderJar(), destination);
                this.alerts.addInfo("Copy " + this.paths.getOpenEJBTomcatLoaderJar().getName() + " to lib");
            }
            catch (IOException e) {
                this.alerts.addError("Unable to copy OpenEJB Tomcat loader jar to Tomcat lib directory.  This will need to be performed manually.", e);
            }
        }
        if ((serverXmlOriginal = Installers.readAll(this.paths.getServerXmlFile(), this.alerts)) == null) {
            return;
        }
        if (serverXmlOriginal.contains(listener)) {
            this.alerts.addWarning("OpenEJB Listener already declared in Tomcat server.xml file.");
            return;
        }
        if (!Installers.backup(this.paths.getServerXmlFile(), this.alerts)) {
            return;
        }
        String newServerXml = null;
        try {
            newServerXml = Installers.replace(serverXmlOriginal, "<Server", "<Server", ">", ">\r\n  <!-- TomEE plugin for Tomcat -->\r\n  <Listener className=\"" + listener + "\" />");
        }
        catch (IOException e) {
            this.alerts.addError("Error while adding listener to server.xml file", e);
        }
        if (Installers.writeAll(this.paths.getServerXmlFile(), newServerXml, this.alerts)) {
            this.alerts.addInfo("Add OpenEJB listener to server.xml");
        }
    }

    public void installJavaagent() {
        String catalinaBatOriginal;
        String catalinaShOriginal;
        if (agentInstalled && !this.force) {
            return;
        }
        boolean copyJavaagentJar = true;
        File javaagentJar = new File(this.paths.getCatalinaLibDir(), "openejb-javaagent.jar");
        if (javaagentJar.exists() && this.paths.getOpenEJBJavaagentJar().length() == javaagentJar.length()) {
            copyJavaagentJar = false;
        }
        if (copyJavaagentJar) {
            try {
                Installers.copyFile(this.paths.getOpenEJBJavaagentJar(), javaagentJar);
                this.alerts.addInfo("Copy " + this.paths.getOpenEJBJavaagentJar().getName() + " to lib");
            }
            catch (IOException e) {
                this.alerts.addError("Unable to copy OpenEJB javaagent jar to Tomcat lib directory.  This will need to be performed manually.", e);
            }
        }
        if ((catalinaShOriginal = Installers.readAll(this.paths.getCatalinaShFile(), this.alerts)) == null) {
            return;
        }
        if (catalinaShOriginal.contains("Add OpenEJB javaagent")) {
            this.alerts.addWarning("OpenEJB javaagent already declared in Tomcat catalina.sh file.");
            return;
        }
        if (!Installers.backup(this.paths.getCatalinaShFile(), this.alerts)) {
            return;
        }
        String openejbJavaagentPath = this.paths.getCatalinaHomeDir().toURI().relativize(javaagentJar.toURI()).getPath();
        String newCatalinaSh = catalinaShOriginal.replace("# ----- Execute The Requested Command", "# Add OpenEJB javaagent\nif [ -r \"$CATALINA_HOME\"/" + openejbJavaagentPath + " ]; then\n" + "  JAVA_OPTS=\"\"-javaagent:$CATALINA_HOME/" + openejbJavaagentPath + "\" $JAVA_OPTS\"\n" + "fi\n" + "\n" + "# ----- Execute The Requested Command");
        if (Installers.writeAll(this.paths.getCatalinaShFile(), newCatalinaSh, this.alerts)) {
            this.alerts.addInfo("Add OpenEJB JavaAgent to catalina.sh");
        }
        if ((catalinaBatOriginal = Installers.readAll(this.paths.getCatalinaBatFile(), this.alerts)) == null) {
            return;
        }
        if (catalinaBatOriginal.contains("Add OpenEJB javaagent")) {
            this.alerts.addWarning("OpenEJB javaagent already declared in Tomcat catalina.bat file.");
            return;
        }
        if (!Installers.backup(this.paths.getCatalinaBatFile(), this.alerts)) {
            return;
        }
        openejbJavaagentPath = openejbJavaagentPath.replace('/', '\\');
        String newCatalinaBat = catalinaBatOriginal.replace("rem ----- Execute The Requested Command", "rem Add OpenEJB javaagent\r\nif not exist \"%CATALINA_HOME%\\" + openejbJavaagentPath + "\" goto noOpenEJBJavaagent\r\n" + "set JAVA_OPTS=\"-javaagent:%CATALINA_HOME%\\" + openejbJavaagentPath + "\" %JAVA_OPTS%\r\n" + ":noOpenEJBJavaagent\r\n" + "\r\n" + "rem ----- Execute The Requested Command");
        if (Installers.writeAll(this.paths.getCatalinaBatFile(), newCatalinaBat, this.alerts)) {
            this.alerts.addInfo("Add OpenEJB JavaAgent to catalina.bat");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installConfigFiles() {
        JarFile openejbTomcatCommonJar;
        File openejbSystemProperties;
        String openejbLoggingProps;
        String openEjbXml;
        JarFile coreJar;
        File openejbCoreJar = this.paths.getOpenEJBCoreJar();
        File confDir = this.paths.getCatalinaConfDir();
        Alerts alerts = this.alerts;
        if (openejbCoreJar == null) {
            return;
        }
        try {
            coreJar = new JarFile(openejbCoreJar);
        }
        catch (IOException e) {
            return;
        }
        File openEjbXmlFile = new File(confDir, "tomee.xml");
        if (!openEjbXmlFile.exists() && (openEjbXml = Installers.readEntry(coreJar, "default.openejb.conf", alerts)) != null && Installers.writeAll(openEjbXmlFile, openEjbXml.replace("<openejb>", "<tomee>").replace("</openejb>", "</tomee>"), alerts)) {
            alerts.addInfo("Copy tomee.xml to conf");
        }
        if ((openejbLoggingProps = Installers.readEntry(coreJar, "logging.properties", alerts)) != null) {
            File loggingPropsFile = new File(confDir, "logging.properties");
            String newLoggingProps = null;
            if (!loggingPropsFile.exists()) {
                newLoggingProps = openejbLoggingProps;
            } else {
                String loggingPropsOriginal = Installers.readAll(loggingPropsFile, alerts);
                if (!loggingPropsOriginal.toLowerCase().contains("openejb")) {
                    String[] strings = openejbLoggingProps.split("## --*", 3);
                    if (strings.length == 3) {
                        openejbLoggingProps = strings[2];
                    }
                    newLoggingProps = loggingPropsOriginal + "\r\n" + "############################################################\r\n" + "# OpenEJB Logging Configuration.\r\n" + "############################################################\r\n" + openejbLoggingProps + "\r\n";
                }
            }
            if (newLoggingProps != null && Installers.writeAll(loggingPropsFile, newLoggingProps, alerts)) {
                alerts.addInfo("Append OpenEJB config to logging.properties");
            }
        }
        if (!(openejbSystemProperties = new File(confDir, "system.properties")).exists()) {
            FileWriter systemPropertiesWriter = null;
            try {
                systemPropertiesWriter = new FileWriter(openejbSystemProperties);
                systemPropertiesWriter.write("# all this properties are added at JVM system properties at startup\n");
                systemPropertiesWriter.write("# here some default Apache TomEE system properties\n");
                systemPropertiesWriter.write("# for more information please see http://openejb.apache.org/properties-listing.html\n");
                systemPropertiesWriter.write("\n");
                systemPropertiesWriter.write("# openejb.check.classloader = false\n");
                systemPropertiesWriter.write("# openejb.check.classloader.verbose = false\n");
                systemPropertiesWriter.write("\n");
                systemPropertiesWriter.write("# tomee.jaxws.subcontext = webservices\n");
                systemPropertiesWriter.write("# tomee.jaxws.oldsubcontext = false\n");
                systemPropertiesWriter.write("\n");
                systemPropertiesWriter.write("# openejb.system.apps = true\n");
                systemPropertiesWriter.write("# openejb.servicemanager.enabled = true\n");
                systemPropertiesWriter.write("# openejb.jmx.active = false\n");
                systemPropertiesWriter.write("# openejb.descriptors.output = false\n");
                systemPropertiesWriter.write("# openejb.strict.interface.declaration = false\n");
                systemPropertiesWriter.write("# openejb.conf.file = conf/tomee.xml\n");
                systemPropertiesWriter.write("# openejb.debuggable-vm-hackery = false\n");
                systemPropertiesWriter.write("# openejb.validation.skip = false\n");
                systemPropertiesWriter.write("# openejb.webservices.enabled = true\n");
                systemPropertiesWriter.write("# openejb.validation.output.level = MEDIUM\n");
                systemPropertiesWriter.write("# openejb.user.mbeans.list = *\n");
                systemPropertiesWriter.write("# openejb.deploymentId.format = {appId}/{ejbJarId}/{ejbName}\n");
                systemPropertiesWriter.write("# openejb.jndiname.format = {deploymentId}{interfaceType.annotationName}\n");
                systemPropertiesWriter.write("# openejb.deployments.package.include = .*\n");
                systemPropertiesWriter.write("# openejb.deployments.package.exclude = \n");
                systemPropertiesWriter.write("# openejb.autocreate.jta-datasource-from-non-jta-one = true\n");
                systemPropertiesWriter.write("# openejb.altdd.prefix = \n");
                systemPropertiesWriter.write("# org.apache.openejb.default.system.interceptors = \n");
                systemPropertiesWriter.write("# openejb.jndiname.failoncollision = true\n");
                systemPropertiesWriter.write("# openejb.wsAddress.format = /{ejbDeploymentId}\n");
                systemPropertiesWriter.write("# org.apache.openejb.server.webservices.saaj.provider = \n");
                systemPropertiesWriter.write("# openejb.nobanner = true\n");
                systemPropertiesWriter.write("# openejb.offline = false\n");
                systemPropertiesWriter.write("# openejb.jmx.active = true\n");
                systemPropertiesWriter.write("# openejb.exclude-include.order = include-exclude\n");
                systemPropertiesWriter.write("# openejb.additional.exclude =\n");
                systemPropertiesWriter.write("# openejb.additional.include =\n");
                systemPropertiesWriter.write("# openejb.crosscontext = false\n");
                systemPropertiesWriter.write("# openejb.jsessionid-support = \n");
                systemPropertiesWriter.write("# openejb.myfaces.disable-default-values = true\n");
                systemPropertiesWriter.write("# openejb.web.xml.major = \n");
                systemPropertiesWriter.write("# openjpa.Log = \n");
                systemPropertiesWriter.write("# openejb.jdbc.log = false\n");
                systemPropertiesWriter.write("# javax.persistence.provider = org.apache.openjpa.persistence.PersistenceProviderImpl\n");
                systemPropertiesWriter.write("# javax.persistence.transactionType = \n");
                systemPropertiesWriter.write("# javax.persistence.jtaDataSource = \n");
                systemPropertiesWriter.write("# javax.persistence.nonJtaDataSource = \n");
            }
            catch (IOException e) {
            }
            finally {
                if (systemPropertiesWriter != null) {
                    try {
                        systemPropertiesWriter.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        try {
            openejbTomcatCommonJar = new JarFile(this.paths.geOpenEJBTomcatCommonJar());
        }
        catch (IOException e) {
            return;
        }
        File webXmlFile = new File(confDir, "web.xml");
        String webXml = Installers.readEntry(openejbTomcatCommonJar, "conf/web.xml", alerts);
        if (Installers.writeAll(webXmlFile, webXml, alerts)) {
            alerts.addInfo("Set jasper in production mode in TomEE web.xml");
        }
    }

    public static Object invokeStaticNoArgMethod(String className, String propertyName) {
        try {
            Class<?> clazz = Installer.loadClass(className, Installer.class.getClassLoader());
            Method method = clazz.getMethod(propertyName, new Class[0]);
            return method.invoke(null, (Object[])null);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Class<?> loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        LinkedList<ClassLoader> loaders = new LinkedList<ClassLoader>();
        for (ClassLoader loader = classLoader; loader != null; loader = loader.getParent()) {
            loaders.addFirst(loader);
        }
        for (ClassLoader loader : loaders) {
            try {
                return Class.forName(className, true, loader);
            }
            catch (ClassNotFoundException e) {
            }
        }
        return null;
    }

    public static enum Status {
        NONE,
        INSTALLED,
        REBOOT_REQUIRED;

    }
}

