/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.embedded;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.naming.NamingException;
import javax.xml.bind.JAXBException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.Bootstrap;
import org.apache.catalina.startup.CatalinaProperties;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.http11.Http11Protocol;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.Core;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.sys.JaxbOpenejb;
import org.apache.openejb.config.sys.Openejb;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.DaemonThreadFactory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.catalina.TomEERuntimeException;
import org.apache.tomee.catalina.TomcatLoader;
import org.apache.tomee.embedded.Configuration;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.NullLogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class Container {
    private Bootstrap bootstrap;
    protected Configuration configuration;
    private File base;
    private Map<String, String> moduleIds = new HashMap<String, String>();
    private Map<String, AppContext> appContexts = new HashMap<String, AppContext>();
    private ConfigurationFactory configurationFactory;
    private Assembler assembler;
    private final Tomcat tomcat;

    public Container() {
        Configuration configuration = new Configuration();
        configuration.setHttpPort(23880);
        configuration.setStopPort(23881);
        this.setup(configuration);
        Class<Bootstrap> bootstrapClass = Bootstrap.class;
        this.tomcat = new TomcatWithFastSessionIDs();
    }

    public void setup(Configuration configuration) {
        this.configuration = configuration;
    }

    public void start() throws Exception {
        String dir = this.getBaseDir();
        Logger.configure();
        this.base = new File(dir);
        if (this.base.exists()) {
            this.base.delete();
        }
        this.base.mkdirs();
        this.base.deleteOnExit();
        File conf = this.createDirectory(this.base, "conf");
        File lib = this.createDirectory(this.base, "lib");
        File logs = this.createDirectory(this.base, "logs");
        File webapps = this.createDirectory(this.base, "webapps");
        File temp = this.createDirectory(this.base, "temp");
        File work = this.createDirectory(this.base, "work");
        this.copyFileTo(conf, "catalina.policy");
        this.copyTemplateTo(conf, "catalina.properties");
        this.copyFileTo(conf, "context.xml");
        this.copyFileTo(conf, "openejb.xml");
        this.copyFileTo(conf, "server.xml");
        this.copyFileTo(conf, "tomcat-users.xml");
        this.copyFileTo(conf, "web.xml");
        System.setProperty("catalina.base", this.base.getAbsolutePath());
        CatalinaProperties.getProperty((String)"foo");
        Connector connector = new Connector(Http11Protocol.class.getName());
        connector.setPort(this.configuration.getHttpPort());
        connector.setAttribute("connectionTimeout", (Object)"3000");
        this.tomcat.getService().addConnector(connector);
        this.tomcat.setConnector(connector);
        this.tomcat.setBaseDir(this.base.getAbsolutePath());
        this.tomcat.getHost().setAppBase(webapps.getAbsolutePath());
        System.out.println("Starting TomEE from: " + this.base.getAbsolutePath());
        String catalinaBase = this.base.getAbsolutePath();
        System.setProperty("openejb.deployments.classpath", "false");
        System.setProperty("catalina.home", catalinaBase);
        System.setProperty("catalina.base", catalinaBase);
        System.setProperty("openejb.home", catalinaBase);
        System.setProperty("openejb.base", catalinaBase);
        System.setProperty("openejb.servicemanager.enabled", "false");
        this.tomcat.start();
        Properties properties = new Properties();
        properties.setProperty("openejb.deployments.classpath", "false");
        properties.setProperty("openejb.loader", "tomcat-system");
        properties.setProperty("openejb.home", catalinaBase);
        properties.setProperty("openejb.base", catalinaBase);
        properties.setProperty("openejb.servicemanager.enabled", "false");
        try {
            String serverBuilt;
            String serverInfo;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Properties tomcatServerInfo = IO.readProperties((InputStream)classLoader.getResourceAsStream("org/apache/catalina/util/ServerInfo.properties"), (Properties)new Properties());
            String serverNumber = tomcatServerInfo.getProperty("server.number");
            if (serverNumber == null && (serverInfo = tomcatServerInfo.getProperty("server.info")) != null) {
                int slash = serverInfo.indexOf(47);
                serverNumber = serverInfo.substring(slash + 1);
            }
            if (serverNumber != null) {
                System.setProperty("tomcat.version", serverNumber);
            }
            if ((serverBuilt = tomcatServerInfo.getProperty("server.built")) != null) {
                System.setProperty("tomcat.built", serverBuilt);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        SystemInstance.init((Properties)System.getProperties());
        SystemInstance.get().setComponent(StandardServer.class, (Object)((StandardServer)this.tomcat.getServer()));
        TomcatLoader loader = new TomcatLoader();
        loader.initDefaults(properties);
        loader.initialize(properties);
        this.assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
        this.configurationFactory = new ConfigurationFactory();
    }

    private String getBaseDir() {
        try {
            String dir = this.configuration.getDir();
            if (dir != null) {
                return dir;
            }
            File file = File.createTempFile("apache-tomee", "-home");
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            throw new TomEERuntimeException((Throwable)e);
        }
    }

    public void stop() throws Exception {
        this.tomcat.stop();
        this.deleteTree(this.base);
        OpenEJB.destroy();
    }

    public AppContext deploy(String name, File file) throws OpenEJBException, IOException, NamingException {
        return this.deploy(name, file, false);
    }

    public AppContext deploy(String name, File file, boolean overrideName) throws OpenEJBException, IOException, NamingException {
        AppInfo appInfo = this.configurationFactory.configureApplication(file);
        if (overrideName) {
            appInfo.appId = name;
            for (EjbJarInfo ejbJar : appInfo.ejbJars) {
                if (file.getName().equals(ejbJar.moduleName)) {
                    ejbJar.moduleName = name;
                }
                for (EnterpriseBeanInfo ejb : ejbJar.enterpriseBeans) {
                    if (!BeanContext.Comp.openejbCompName((String)file.getName()).equals(ejb.ejbName)) continue;
                    ejb.ejbName = BeanContext.Comp.openejbCompName((String)name);
                }
            }
            for (WebAppInfo webApp : appInfo.webApps) {
                if (!file.getName().equals(webApp.moduleId)) continue;
                webApp.moduleId = name;
            }
        }
        AppContext context = this.assembler.createApplication(appInfo);
        this.appContexts.put(name, context);
        this.moduleIds.put(name, appInfo.path);
        return context;
    }

    public void undeploy(String name) throws UndeployException, NoSuchApplicationException {
        String moduleId = this.moduleIds.get(name);
        this.assembler.destroyApplication(moduleId);
        this.moduleIds.remove(name);
        this.appContexts.remove(name);
    }

    public javax.naming.Context getJndiContext() {
        return this.assembler.getContainerSystem().getJNDIContext();
    }

    public AppContext getAppContexts(String moduleId) {
        return this.appContexts.get(moduleId);
    }

    private void deleteTree(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        if (file.isDirectory()) {
            File[] children;
            if ("".equals(file.getName())) {
                return;
            }
            if ("src/main".equals(file.getName())) {
                return;
            }
            for (File child : children = file.listFiles()) {
                this.deleteTree(child);
            }
            file.delete();
        }
    }

    private void copyTemplateTo(File targetDir, String filename) throws Exception {
        Velocity.setProperty((String)"runtime.log.logsystem", (Object)new NullLogChute());
        Velocity.setProperty((String)"resource.loader", (Object)"class");
        Velocity.setProperty((String)"class.resource.loader.description", (Object)"Velocity Classpath Resource Loader");
        Velocity.setProperty((String)"class.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        Velocity.init();
        Template template = Velocity.getTemplate((String)("/org/apache/tomee/configs/" + filename));
        VelocityContext context = new VelocityContext();
        context.put("tomcatHttpPort", (Object)Integer.toString(this.configuration.getHttpPort()));
        context.put("tomcatShutdownPort", (Object)Integer.toString(this.configuration.getStopPort()));
        FileWriter writer = new FileWriter(new File(targetDir, filename));
        template.merge((Context)context, (Writer)writer);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileTo(File targetDir, String filename) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/org/apache/tomee/configs/" + filename);
        if (is != null) {
            try {
                IO.copy((InputStream)is, (File)new File(targetDir, filename));
            }
            finally {
                IO.close((Closeable)is);
            }
        }
    }

    private void createTomcatDirectories(File directory) {
        this.createDirectory(directory, "apps");
        this.createDirectory(directory, "conf");
        this.createDirectory(directory, "lib");
        this.createDirectory(directory, "logs");
        this.createDirectory(directory, "webapps");
        this.createDirectory(directory, "temp");
        this.createDirectory(directory, "work");
    }

    private File createDirectory(File parent, String directory) {
        File dir = new File(parent, directory);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Unable to make dir " + dir.getAbsolutePath());
        }
        return dir;
    }

    public void await() {
        this.tomcat.getServer().await();
    }

    static {
        Assembler.installNaming((String)"org.apache.naming", (boolean)true);
        Core.warmup();
        ExecutorService executor = Executors.newFixedThreadPool(4, (ThreadFactory)new DaemonThreadFactory(new Object[]{"warmup"}));
        executor.execute(new JaxbJavaeeLoad(WebApp.class));
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    JaxbOpenejb.getContext(Openejb.class);
                }
                catch (JAXBException jAXBException) {
                    // empty catch block
                }
            }
        });
        executor.execute(new JaxbJavaeeLoad(Persistence.class));
    }

    private static class TomcatWithFastSessionIDs
    extends Tomcat {
        private TomcatWithFastSessionIDs() {
        }

        public void start() throws LifecycleException {
            Server server = this.getServer();
            for (Service service : server.findServices()) {
                org.apache.catalina.Container e = service.getContainer();
                for (org.apache.catalina.Container h : e.findChildren()) {
                    for (org.apache.catalina.Container c : h.findChildren()) {
                        StandardManager m = (StandardManager)c.getManager();
                        if (m != null) continue;
                        m = new StandardManager();
                        m.setSecureRandomClass("org.apache.catalina.startup.FastNonSecureRandom");
                        c.setManager((Manager)m);
                    }
                }
            }
            super.start();
        }
    }

    private static class JaxbJavaeeLoad
    implements Runnable {
        private final Class<?> type;

        private JaxbJavaeeLoad(Class<?> type) {
            this.type = type;
        }

        @Override
        public void run() {
            try {
                JaxbJavaee.getContext(this.type);
            }
            catch (JAXBException jAXBException) {
                // empty catch block
            }
        }
    }
}

