/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.jul.formatter;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.apache.juli.AsyncFileHandler;

public class AsyncConsoleHandler
extends AsyncFileHandler {
    private final ConsoleHandler delegate = new ConsoleHandler(){
        {
            this.setFormatter(new SingleLineFormatter());
        }
    };

    @Override
    protected void publishInternal(LogRecord record) {
        this.delegate.publish(record);
    }

    private static class SingleLineFormatter
    extends Formatter {
        private static final String SEP = System.getProperty("line.separator", "\n");

        private SingleLineFormatter() {
        }

        @Override
        public synchronized String format(LogRecord record) {
            boolean exception = record.getThrown() != null;
            StringBuilder sbuf = new StringBuilder();
            sbuf.append(record.getLevel().getLocalizedName());
            sbuf.append(" - ");
            sbuf.append(this.formatMessage(record));
            sbuf.append(SEP);
            if (exception) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    sbuf.append(sw.toString());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return sbuf.toString();
        }
    }
}

