/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.webservices;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardServer;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.util.HttpUtil;
import org.apache.openejb.server.rest.RsRegistry;
import org.apache.openejb.server.rest.RsServlet;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.catalina.TomEERuntimeException;
import org.apache.tomee.catalina.TomcatWebAppBuilder;
import org.apache.tomee.loader.TomcatHelper;

public class TomcatRsRegistry
implements RsRegistry {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_STARTUP, TomcatRsRegistry.class);
    private Engine engine;
    private List<Connector> connectors;
    private final Map<String, Context> contexts = new TreeMap<String, Context>();
    private final Map<String, HttpListener> listeners = new TreeMap<String, HttpListener>();

    public TomcatRsRegistry() {
        StandardServer standardServer = TomcatHelper.getServer();
        for (Service service : standardServer.findServices()) {
            if (!(service.getContainer() instanceof Engine)) continue;
            this.connectors = Arrays.asList(service.findConnectors());
            this.engine = (Engine)service.getContainer();
            break;
        }
    }

    public RsRegistry.AddressInfo createRsHttpListener(String root, HttpListener listener, ClassLoader classLoader, String completePath, String virtualHost) {
        Container host;
        int idx;
        String path = completePath;
        if (path == null) {
            throw new NullPointerException("contextRoot is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        String realRoot = root;
        if (!root.startsWith("/")) {
            realRoot = "/" + root;
        }
        if (realRoot.length() > 1 && (idx = realRoot.substring(1).indexOf(47)) > 0) {
            realRoot = realRoot.substring(0, idx + 1);
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!"/".equals(realRoot)) {
            path = path.substring(realRoot.length(), path.length());
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (virtualHost == null) {
            virtualHost = this.engine.getDefaultHost();
        }
        if ((host = this.engine.findChild(virtualHost)) == null) {
            throw new IllegalArgumentException("Invalid virtual host '" + virtualHost + "'.  Do you have a matching Host entry in the server.xml?");
        }
        Context context = (Context)host.findChild(realRoot);
        if (context == null && "/".equals(realRoot)) {
            context = (Context)host.findChild("");
        }
        if (context == null) {
            throw new IllegalStateException("Invalid context '" + realRoot + "'.  Cannot find context in host " + host.getName());
        }
        context.addLifecycleListener(new LifecycleListener(){

            public void lifecycleEvent(LifecycleEvent event) {
                Context context = (Context)event.getLifecycle();
                if (event.getType().equals("before_start")) {
                    context.getServletContext().setAttribute(TomcatWebAppBuilder.IGNORE_CONTEXT, (Object)"true");
                }
                if (event.getType().equals("start") || event.getType().equals("before_start") || event.getType().equals("configure_start")) {
                    context.setConfigured(true);
                }
            }
        });
        Wrapper wrapper = context.createWrapper();
        String name = "rest_" + listener.hashCode();
        wrapper.setName(name);
        wrapper.setServletClass(RsServlet.class.getName());
        String mapping = path.replace("/.*", "/*");
        context.addChild((Container)wrapper);
        wrapper.addMapping(mapping);
        context.addServletMapping(mapping, name);
        String listenerId = wrapper.getName() + RsServlet.class.getName() + listener.hashCode();
        wrapper.addInitParameter(HttpListener.class.getName(), listenerId);
        context.getServletContext().setAttribute(listenerId, (Object)listener);
        path = TomcatRsRegistry.address(this.connectors, host.getName(), realRoot);
        String key = TomcatRsRegistry.address(this.connectors, host.getName(), completePath);
        this.contexts.put(key, context);
        this.listeners.put(key, listener);
        return new RsRegistry.AddressInfo(path, key);
    }

    private static String address(Collection<Connector> connectors, String host, String path) {
        ArrayList<String> addresses = new ArrayList<String>();
        for (Connector connector : connectors) {
            URI address;
            try {
                address = new URI(connector.getScheme(), null, host, connector.getPort(), path, null, null);
            }
            catch (Exception e) {
                LOGGER.error("can't add container for path " + path, (Throwable)e);
                continue;
            }
            addresses.add(address.toString());
        }
        return HttpUtil.selectSingleAddress(addresses);
    }

    public HttpListener removeListener(String completePath) {
        String path = completePath;
        if (path == null) {
            return this.listeners.get(path);
        }
        if (!(path.startsWith("/") || path.startsWith("http://") || path.startsWith("https://"))) {
            path = "/" + path;
        }
        if (TomcatHelper.isTomcat7() && TomcatHelper.isStopping() && this.listeners.containsKey(path)) {
            return this.listeners.get(path);
        }
        Context context = this.contexts.remove(path);
        try {
            context.stop();
            context.destroy();
        }
        catch (Exception e) {
            throw new TomEERuntimeException((Throwable)e);
        }
        Host host = (Host)context.getParent();
        host.removeChild((Container)context);
        return this.listeners.remove(completePath);
    }
}

