/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.webservices;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.BasicAuthenticator;
import org.apache.catalina.authenticator.DigestAuthenticator;
import org.apache.catalina.authenticator.NonLoginAuthenticator;
import org.apache.catalina.authenticator.SSLAuthenticator;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.webservices.WsRegistry;
import org.apache.openejb.server.webservices.WsServlet;
import org.apache.tomee.catalina.BackportUtil;
import org.apache.tomee.catalina.OpenEJBValve;
import org.apache.tomee.catalina.TomEERuntimeException;
import org.apache.tomee.catalina.TomcatWebAppBuilder;
import org.apache.tomee.loader.TomcatHelper;

public class TomcatWsRegistry
implements WsRegistry {
    private static final String WEBSERVICE_SUB_CONTEXT = TomcatWsRegistry.forceSlash(SystemInstance.get().getOptions().get("tomee.jaxws.subcontext", "/webservices"));
    private static final boolean WEBSERVICE_OLDCONTEXT_ACTIVE = SystemInstance.get().getOptions().get("tomee.jaxws.oldsubcontext", false);
    private final Map<String, Context> webserviceContexts = new TreeMap<String, Context>();
    private Engine engine;
    private List<Connector> connectors;

    public TomcatWsRegistry() {
        StandardServer standardServer = TomcatHelper.getServer();
        for (Service service : standardServer.findServices()) {
            if (!(service.getContainer() instanceof Engine)) continue;
            this.connectors = Arrays.asList(service.findConnectors());
            this.engine = (Engine)service.getContainer();
            break;
        }
    }

    private static String forceSlash(String property) {
        if (property == null) {
            return "/";
        }
        if (!property.startsWith("/")) {
            return "/" + property;
        }
        return property;
    }

    public List<String> setWsContainer(String virtualHost, String contextRoot, String servletName, HttpListener wsContainer) throws Exception {
        Container host;
        if (virtualHost == null) {
            virtualHost = this.engine.getDefaultHost();
        }
        if ((host = this.engine.findChild(virtualHost)) == null) {
            throw new IllegalArgumentException("Invalid virtual host '" + virtualHost + "'.  Do you have a matchiing Host entry in the server.xml?");
        }
        Context context = (Context)host.findChild("/" + contextRoot);
        if (context == null) {
            throw new IllegalArgumentException("Could not find web application context " + contextRoot + " in host " + host.getName());
        }
        Wrapper wrapper = (Wrapper)context.findChild(servletName);
        if (wrapper == null) {
            throw new IllegalArgumentException("Could not find servlet " + servletName + " in web application context " + context.getName());
        }
        wrapper.setServletClass(WsServlet.class.getName());
        if (BackportUtil.getServlet((Wrapper)wrapper) != null) {
            wrapper.load();
            wrapper.unload();
        }
        this.setWsContainer(context, wrapper, wsContainer);
        ArrayList<String> addresses = new ArrayList<String>();
        for (Connector connector : this.connectors) {
            for (String mapping : wrapper.findMappings()) {
                URI address = new URI(connector.getScheme(), null, host.getName(), connector.getPort(), "/" + contextRoot + mapping, null, null);
                addresses.add(address.toString());
            }
        }
        return addresses;
    }

    public void clearWsContainer(String virtualHost, String contextRoot, String servletName) {
        Container host;
        if (virtualHost == null) {
            virtualHost = this.engine.getDefaultHost();
        }
        if ((host = this.engine.findChild(virtualHost)) == null) {
            throw new IllegalArgumentException("Invalid virtual host '" + virtualHost + "'.  Do you have a matchiing Host entry in the server.xml?");
        }
        Context context = (Context)host.findChild("/" + contextRoot);
        if (context == null) {
            throw new IllegalArgumentException("Could not find web application context " + contextRoot + " in host " + host.getName());
        }
        Wrapper wrapper = (Wrapper)context.findChild(servletName);
        if (wrapper == null) {
            throw new IllegalArgumentException("Could not find servlet " + servletName + " in web application context " + context.getName());
        }
        String webServicecontainerId = wrapper.findInitParameter(WsServlet.WEBSERVICE_CONTAINER);
        if (webServicecontainerId != null) {
            context.getServletContext().removeAttribute(webServicecontainerId);
            wrapper.removeInitParameter(WsServlet.WEBSERVICE_CONTAINER);
        }
    }

    public List<String> addWsContainer(String webContext, String path, HttpListener httpListener, String virtualHost, String realmName, String transportGuarantee, String authMethod, ClassLoader classLoader) throws Exception {
        Container host;
        if (path == null) {
            throw new NullPointerException("contextRoot is null");
        }
        if (httpListener == null) {
            throw new NullPointerException("httpListener is null");
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (virtualHost == null) {
            virtualHost = this.engine.getDefaultHost();
        }
        if ((host = this.engine.findChild(virtualHost)) == null) {
            throw new IllegalArgumentException("Invalid virtual host '" + virtualHost + "'.  Do you have a matchiing Host entry in the server.xml?");
        }
        ArrayList<String> addresses = new ArrayList<String>();
        if (WEBSERVICE_OLDCONTEXT_ACTIVE) {
            Context context = TomcatWsRegistry.createNewContext(path, classLoader, authMethod, transportGuarantee, realmName);
            host.addChild((Container)context);
            this.addServlet(host, context, "/*", httpListener, path, addresses);
        }
        if (webContext != null) {
            String root = webContext;
            if (!root.startsWith("/")) {
                root = '/' + root;
            }
            Context webAppContext = (Context)host.findChild(root);
            if (WEBSERVICE_SUB_CONTEXT.equals("/") && path.startsWith("/")) {
                this.addServlet(host, webAppContext, path, httpListener, path, addresses);
            } else if (WEBSERVICE_SUB_CONTEXT.equals("/") && !path.startsWith("/")) {
                this.addServlet(host, webAppContext, '/' + path, httpListener, path, addresses);
            } else {
                this.addServlet(host, webAppContext, WEBSERVICE_SUB_CONTEXT + path, httpListener, path, addresses);
            }
        }
        return addresses;
    }

    private static Context createNewContext(String path, ClassLoader classLoader, String authMethod, String transportGuarantee, String realmName) {
        StandardContext context = new StandardContext();
        context.setPath(path);
        context.setDocBase("");
        context.setParentClassLoader(classLoader);
        context.setDelegate(true);
        context.addLifecycleListener(new LifecycleListener(){

            public void lifecycleEvent(LifecycleEvent event) {
                Context context = (Context)event.getLifecycle();
                if (event.getType().equals("before_start")) {
                    context.getServletContext().setAttribute(TomcatWebAppBuilder.IGNORE_CONTEXT, (Object)"true");
                }
                if (event.getType().equals("start") || event.getType().equals("before_start") || event.getType().equals("configure_start")) {
                    context.setConfigured(true);
                }
            }
        });
        if (authMethod != null) {
            authMethod = authMethod.toUpperCase();
        }
        if (transportGuarantee != null) {
            transportGuarantee = transportGuarantee.toUpperCase();
        }
        if (authMethod != null && !"NONE".equals(authMethod)) {
            if ("BASIC".equals(authMethod) || "DIGEST".equals(authMethod) || "CLIENT-CERT".equals(authMethod)) {
                LoginConfig loginConfig = new LoginConfig();
                loginConfig.setAuthMethod(authMethod);
                loginConfig.setRealmName(realmName);
                context.setLoginConfig(loginConfig);
                SecurityCollection collection = new SecurityCollection();
                collection.addMethod("GET");
                collection.addMethod("POST");
                collection.addPattern("/*");
                collection.setName("default");
                SecurityConstraint sc = new SecurityConstraint();
                sc.addAuthRole("*");
                sc.addCollection(collection);
                sc.setAuthConstraint(true);
                sc.setUserConstraint(transportGuarantee);
                context.addConstraint(sc);
                context.addSecurityRole("default");
                if ("BASIC".equals(authMethod)) {
                    context.addValve((Valve)new BasicAuthenticator());
                } else if ("DIGEST".equals(authMethod)) {
                    context.addValve((Valve)new DigestAuthenticator());
                } else if ("CLIENT-CERT".equals(authMethod)) {
                    context.addValve((Valve)new SSLAuthenticator());
                } else if ("NONE".equals(authMethod)) {
                    context.addValve((Valve)new NonLoginAuthenticator());
                }
                OpenEJBValve openejbValve = new OpenEJBValve();
                context.getPipeline().addValve((Valve)openejbValve);
            } else {
                throw new IllegalArgumentException("Invalid authMethod: " + authMethod);
            }
        }
        return context;
    }

    private void addServlet(Container host, Context context, String mapping, HttpListener httpListener, String path, List<String> addresses) {
        Wrapper wrapper = context.createWrapper();
        wrapper.setName("webservice" + path.substring(1));
        wrapper.setServletClass(WsServlet.class.getName());
        context.addChild((Container)wrapper);
        context.addServletMapping(mapping, wrapper.getName());
        String webServicecontainerID = wrapper.getName() + WsServlet.WEBSERVICE_CONTAINER + httpListener.hashCode();
        wrapper.addInitParameter(WsServlet.WEBSERVICE_CONTAINER, webServicecontainerID);
        context.getServletContext().setAttribute(TomcatWebAppBuilder.IGNORE_CONTEXT, (Object)"true");
        this.setWsContainer(context, wrapper, httpListener);
        this.webserviceContexts.put(path, context);
        for (Connector connector : this.connectors) {
            StringBuilder fullContextpath;
            if (!WEBSERVICE_OLDCONTEXT_ACTIVE) {
                String contextPath = context.getName();
                if (contextPath != null && !contextPath.startsWith("/")) {
                    contextPath = "/" + contextPath;
                } else if (contextPath == null) {
                    contextPath = "/";
                }
                fullContextpath = new StringBuilder(contextPath);
                if (!WEBSERVICE_SUB_CONTEXT.equals("/")) {
                    fullContextpath.append(WEBSERVICE_SUB_CONTEXT);
                }
                fullContextpath.append(path);
            } else {
                fullContextpath = new StringBuilder(path);
            }
            try {
                URI address = new URI(connector.getScheme(), null, host.getName(), connector.getPort(), fullContextpath.toString(), null, null);
                addresses.add(address.toString());
            }
            catch (URISyntaxException ignored) {}
        }
    }

    public void removeWsContainer(String path) {
        if (path == null) {
            return;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (TomcatHelper.isTomcat7() && TomcatHelper.isStopping()) {
            return;
        }
        Context context = this.webserviceContexts.remove(path);
        if (WEBSERVICE_OLDCONTEXT_ACTIVE) {
            try {
                context.destroy();
                context.stop();
            }
            catch (Exception e) {
                throw new TomEERuntimeException((Throwable)e);
            }
            Host host = (Host)context.getParent();
            host.removeChild((Container)context);
        }
    }

    private void setWsContainer(Context context, Wrapper wrapper, HttpListener wsContainer) {
        String webServicecontainerID = wrapper.getName() + WsServlet.WEBSERVICE_CONTAINER + wsContainer.hashCode();
        context.getServletContext().setAttribute(webServicecontainerID, (Object)wsContainer);
        wrapper.addInitParameter(WsServlet.WEBSERVICE_CONTAINER, webServicecontainerID);
    }
}

