/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.record;

import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.poi.hwmf.draw.HwmfDrawProperties;
import org.apache.poi.hwmf.draw.HwmfGraphics;
import org.apache.poi.hwmf.record.HwmfBinaryRasterOp;
import org.apache.poi.hwmf.record.HwmfBitmap16;
import org.apache.poi.hwmf.record.HwmfBitmapDib;
import org.apache.poi.hwmf.record.HwmfBrushStyle;
import org.apache.poi.hwmf.record.HwmfColorRef;
import org.apache.poi.hwmf.record.HwmfFill;
import org.apache.poi.hwmf.record.HwmfHatchStyle;
import org.apache.poi.hwmf.record.HwmfMapMode;
import org.apache.poi.hwmf.record.HwmfObjectTableEntry;
import org.apache.poi.hwmf.record.HwmfPenStyle;
import org.apache.poi.hwmf.record.HwmfRecord;
import org.apache.poi.hwmf.record.HwmfRecordType;
import org.apache.poi.util.LittleEndianInputStream;

public class HwmfMisc {

    public static class WmfCreateBrushIndirect
    implements HwmfRecord,
    HwmfObjectTableEntry {
        private HwmfBrushStyle brushStyle;
        private HwmfColorRef colorRef;
        private HwmfHatchStyle brushHatch;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.createBrushIndirect;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.brushStyle = HwmfBrushStyle.valueOf(leis.readUShort());
            this.colorRef = new HwmfColorRef();
            int size = this.colorRef.init(leis);
            this.brushHatch = HwmfHatchStyle.valueOf(leis.readUShort());
            return size + 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.addObjectTableEntry(this);
        }

        @Override
        public void applyObject(HwmfGraphics ctx) {
            HwmfDrawProperties p = ctx.getProperties();
            p.setBrushStyle(this.brushStyle);
            p.setBrushColor(this.colorRef);
            p.setBrushHatch(this.brushHatch);
        }
    }

    public static class WmfCreatePenIndirect
    implements HwmfRecord,
    HwmfObjectTableEntry {
        private HwmfPenStyle penStyle;
        private int xWidth;
        private int yWidth;
        private HwmfColorRef colorRef;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.createPenIndirect;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.penStyle = HwmfPenStyle.valueOf(leis.readUShort());
            this.xWidth = leis.readShort();
            this.yWidth = leis.readShort();
            this.colorRef = new HwmfColorRef();
            int size = this.colorRef.init(leis);
            return size + 6;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.addObjectTableEntry(this);
        }

        @Override
        public void applyObject(HwmfGraphics ctx) {
            HwmfDrawProperties p = ctx.getProperties();
            p.setPenStyle(this.penStyle);
            p.setPenColor(this.colorRef);
            p.setPenWidth(this.xWidth);
        }
    }

    public static class WmfCreatePatternBrush
    implements HwmfRecord,
    HwmfObjectTableEntry {
        private HwmfBitmap16 pattern;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.createPatternBrush;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.pattern = new HwmfBitmap16(true);
            return this.pattern.init(leis);
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.addObjectTableEntry(this);
        }

        @Override
        public void applyObject(HwmfGraphics ctx) {
            HwmfDrawProperties dp = ctx.getProperties();
            dp.setBrushBitmap(this.pattern.getImage());
            dp.setBrushStyle(HwmfBrushStyle.BS_PATTERN);
        }
    }

    public static class WmfDeleteObject
    implements HwmfRecord {
        private int objectIndex;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.deleteObject;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.objectIndex = leis.readUShort();
            return 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.unsetObjectTableEntry(this.objectIndex);
        }
    }

    public static class WmfDibCreatePatternBrush
    implements HwmfRecord,
    HwmfFill.HwmfImageRecord,
    HwmfObjectTableEntry {
        private HwmfBrushStyle style;
        private HwmfFill.ColorUsage colorUsage;
        private HwmfBitmapDib patternDib;
        private HwmfBitmap16 pattern16;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.dibCreatePatternBrush;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.style = HwmfBrushStyle.valueOf(leis.readUShort());
            this.colorUsage = HwmfFill.ColorUsage.valueOf(leis.readUShort());
            int size = 4;
            switch (this.style) {
                case BS_SOLID: 
                case BS_NULL: 
                case BS_DIBPATTERN: 
                case BS_DIBPATTERNPT: 
                case BS_HATCHED: 
                case BS_PATTERN: {
                    this.patternDib = new HwmfBitmapDib();
                    size += this.patternDib.init(leis, (int)(recordSize - 6L - (long)size));
                    break;
                }
                case BS_INDEXED: 
                case BS_DIBPATTERN8X8: 
                case BS_MONOPATTERN: 
                case BS_PATTERN8X8: {
                    throw new RuntimeException("pattern not supported");
                }
            }
            return size;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.addObjectTableEntry(this);
        }

        @Override
        public void applyObject(HwmfGraphics ctx) {
            HwmfDrawProperties prop = ctx.getProperties();
            prop.setBrushStyle(this.style);
            prop.setBrushBitmap(this.getImage());
        }

        @Override
        public BufferedImage getImage() {
            if (this.patternDib != null) {
                return this.patternDib.getImage();
            }
            if (this.pattern16 != null) {
                return this.pattern16.getImage();
            }
            return null;
        }
    }

    public static class WmfSetStretchBltMode
    implements HwmfRecord {
        private int setStretchBltMode;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.setStretchBltMode;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.setStretchBltMode = leis.readUShort();
            return 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }
    }

    public static class WmfSetRop2
    implements HwmfRecord {
        private HwmfBinaryRasterOp drawMode;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.setRop2;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.drawMode = HwmfBinaryRasterOp.valueOf(leis.readUShort());
            return 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }
    }

    public static class WmfSetMapperFlags
    implements HwmfRecord {
        private long mapperValues;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.setMapperFlags;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.mapperValues = leis.readUInt();
            return 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }
    }

    public static class WmfSetMapMode
    implements HwmfRecord {
        private HwmfMapMode mapMode;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.setMapMode;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.mapMode = HwmfMapMode.valueOf(leis.readUShort());
            return 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.getProperties().setMapMode(this.mapMode);
            ctx.updateWindowMapMode();
        }
    }

    public static class WmfSetLayout
    implements HwmfRecord {
        private int layout;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.setLayout;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.layout = leis.readUShort();
            short reserved = leis.readShort();
            return 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }
    }

    public static class WmfSetBkMode
    implements HwmfRecord {
        private HwmfBkMode bkMode;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.setBkMode;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.bkMode = HwmfBkMode.valueOf(leis.readUShort());
            return 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.getProperties().setBkMode(this.bkMode);
        }

        public static enum HwmfBkMode {
            TRANSPARENT(1),
            OPAQUE(2);

            int flag;

            private HwmfBkMode(int flag) {
                this.flag = flag;
            }

            static HwmfBkMode valueOf(int flag) {
                for (HwmfBkMode bs : HwmfBkMode.values()) {
                    if (bs.flag != flag) continue;
                    return bs;
                }
                return null;
            }
        }
    }

    public static class WmfSetBkColor
    implements HwmfRecord {
        private HwmfColorRef colorRef;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.setBkColor;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.colorRef = new HwmfColorRef();
            return this.colorRef.init(leis);
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.getProperties().setBackgroundColor(this.colorRef);
        }
    }

    public static class WmfRestoreDc
    implements HwmfRecord {
        private int nSavedDC;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.restoreDc;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.nSavedDC = leis.readShort();
            return 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.restoreProperties(this.nSavedDC);
        }
    }

    public static class WmfSetRelabs
    implements HwmfRecord {
        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.setRelabs;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            return 0;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }
    }

    public static class WmfSaveDc
    implements HwmfRecord {
        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.saveDc;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            return 0;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.saveProperties();
        }
    }
}

