/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import org.apache.poi.hslf.usermodel.HSLFPictureData;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.Units;

public abstract class Metafile
extends HSLFPictureData {
    protected static byte[] compress(byte[] bytes, int offset, int length) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DeflaterOutputStream deflater = new DeflaterOutputStream(out);
        deflater.write(bytes, offset, length);
        deflater.close();
        return out.toByteArray();
    }

    public Dimension getImageDimension() {
        int prefixLen = 16 * this.uidInstanceCount;
        Header header = new Header();
        header.read(this.getRawData(), prefixLen);
        return new Dimension((int)Math.round(Units.toPoints((long)((long)header.size.getWidth()))), (int)Math.round(Units.toPoints((long)((long)header.size.getHeight()))));
    }

    public static class Header {
        public int wmfsize;
        public Rectangle bounds;
        public Dimension size;
        public int zipsize;
        public int compression = 0;
        public int filter = 254;

        public void read(byte[] data, int offset) {
            int pos = offset;
            this.wmfsize = LittleEndian.getInt((byte[])data, (int)pos);
            int left = LittleEndian.getInt((byte[])data, (int)(pos += 4));
            int top = LittleEndian.getInt((byte[])data, (int)(pos += 4));
            int right = LittleEndian.getInt((byte[])data, (int)(pos += 4));
            int bottom = LittleEndian.getInt((byte[])data, (int)(pos += 4));
            this.bounds = new Rectangle(left, top, right - left, bottom - top);
            int width = LittleEndian.getInt((byte[])data, (int)(pos += 4));
            int height = LittleEndian.getInt((byte[])data, (int)(pos += 4));
            this.size = new Dimension(width, height);
            this.zipsize = LittleEndian.getInt((byte[])data, (int)(pos += 4));
            this.compression = LittleEndian.getUByte((byte[])data, (int)(pos += 4));
            this.filter = LittleEndian.getUByte((byte[])data, (int)(++pos));
            ++pos;
        }

        public void write(OutputStream out) throws IOException {
            byte[] header = new byte[34];
            int pos = 0;
            LittleEndian.putInt((byte[])header, (int)pos, (int)this.wmfsize);
            LittleEndian.putInt((byte[])header, (int)(pos += 4), (int)this.bounds.x);
            LittleEndian.putInt((byte[])header, (int)(pos += 4), (int)this.bounds.y);
            LittleEndian.putInt((byte[])header, (int)(pos += 4), (int)(this.bounds.x + this.bounds.width));
            LittleEndian.putInt((byte[])header, (int)(pos += 4), (int)(this.bounds.y + this.bounds.height));
            LittleEndian.putInt((byte[])header, (int)(pos += 4), (int)this.size.width);
            LittleEndian.putInt((byte[])header, (int)(pos += 4), (int)this.size.height);
            LittleEndian.putInt((byte[])header, (int)(pos += 4), (int)this.zipsize);
            header[pos += 4] = 0;
            header[++pos] = (byte)this.filter;
            ++pos;
            out.write(header);
        }

        public int getSize() {
            return 34;
        }
    }
}

