/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv;

import org.apache.samza.config.Config;
import org.apache.samza.container.SamzaContainerContext;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.Options;
import org.rocksdb.TableFormatConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDbOptionsHelper {
    private static final Logger log = LoggerFactory.getLogger(RocksDbOptionsHelper.class);

    public static Options options(Config storeConfig, SamzaContainerContext containerContext) {
        String compactionStyleInConfig;
        String compressionInConfig;
        Options options = new Options();
        Long writeBufSize = storeConfig.getLong("container.write.buffer.size.bytes", 0x2000000L);
        int numTasks = containerContext.taskNames.size();
        options.setWriteBufferSize((long)((int)(writeBufSize / (long)numTasks)));
        CompressionType compressionType = CompressionType.SNAPPY_COMPRESSION;
        switch (compressionInConfig = storeConfig.get("rocksdb.compression", "snappy")) {
            case "snappy": {
                compressionType = CompressionType.SNAPPY_COMPRESSION;
                break;
            }
            case "bzip2": {
                compressionType = CompressionType.BZLIB2_COMPRESSION;
                break;
            }
            case "zlib": {
                compressionType = CompressionType.ZLIB_COMPRESSION;
                break;
            }
            case "lz4": {
                compressionType = CompressionType.LZ4_COMPRESSION;
                break;
            }
            case "lz4hc": {
                compressionType = CompressionType.LZ4HC_COMPRESSION;
                break;
            }
            case "none": {
                compressionType = CompressionType.NO_COMPRESSION;
            }
            default: {
                log.warn("Unknown rocksdb.compression codec " + compressionInConfig + ", overwriting to Snappy");
            }
        }
        options.setCompressionType(compressionType);
        Long cacheSize = storeConfig.getLong("container.cache.size.bytes", 0x6400000L);
        Long cacheSizePerContainer = cacheSize / (long)numTasks;
        int blockSize = storeConfig.getInt("rocksdb.block.size.bytes", 4096);
        BlockBasedTableConfig tableOptions = new BlockBasedTableConfig();
        tableOptions.setBlockCacheSize(cacheSizePerContainer.longValue()).setBlockSize((long)blockSize);
        options.setTableFormatConfig((TableFormatConfig)tableOptions);
        CompactionStyle compactionStyle = CompactionStyle.UNIVERSAL;
        switch (compactionStyleInConfig = storeConfig.get("rocksdb.compaction.style", "universal")) {
            case "universal": {
                compactionStyle = CompactionStyle.UNIVERSAL;
                break;
            }
            case "fifo": {
                compactionStyle = CompactionStyle.FIFO;
                break;
            }
            case "level": {
                compactionStyle = CompactionStyle.LEVEL;
                break;
            }
            default: {
                log.warn("Unknown rocksdb.compactionStyle " + compactionStyleInConfig + ", overwriting to universal");
            }
        }
        options.setCompactionStyle(compactionStyle);
        options.setMaxWriteBufferNumber(storeConfig.getInt("rocksdb.num.write.buffers", 3));
        options.setCreateIfMissing(true);
        options.setErrorIfExists(false);
        return options;
    }
}

