/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv;

import java.io.File;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.storage.kv.KeyValueStoreMetrics;
import org.apache.samza.storage.kv.KeyValueStoreMetrics$;
import org.apache.samza.util.Logging;
import org.rocksdb.FlushOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.TtlDB;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class RocksDbKeyValueStore$
implements Logging {
    public static final RocksDbKeyValueStore$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    static {
        new RocksDbKeyValueStore$();
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        RocksDbKeyValueStore$ rocksDbKeyValueStore$ = this;
        synchronized (rocksDbKeyValueStore$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        RocksDbKeyValueStore$ rocksDbKeyValueStore$ = this;
        synchronized (rocksDbKeyValueStore$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging.class.startupLogger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    public void startupLog(Function0<Object> message) {
        Logging.class.startupLog((Logging)this, message);
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, message, e);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, message, e);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.info((Logging)this, message, e);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, message, e);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.error((Logging)this, message, e);
    }

    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging.class.putMDC((Logging)this, key, value);
    }

    public String getMDC(Function0<String> key) {
        return Logging.class.getMDC((Logging)this, key);
    }

    public void removeMDC(Function0<String> key) {
        Logging.class.removeMDC((Logging)this, key);
    }

    public void clearMDC() {
        Logging.class.clearMDC((Logging)this);
    }

    /*
     * Loose catch block
     */
    public RocksDB openDB(File dir, Options options, Config storeConfig, boolean isLoggedStore, String storeName) {
        boolean useTTL;
        LongRef ttl;
        block10: {
            ttl = LongRef.create((long)0L);
            useTTL = false;
            if (storeConfig.containsKey((Object)"rocksdb.ttl.ms")) {
                ttl.elem = storeConfig.getLong("rocksdb.ttl.ms");
                if (ttl.elem > 0L) {
                    if (ttl.elem < 1000L) {
                        this.warn((Function0<Object>)new Serializable(storeName, ttl){
                            public static final long serialVersionUID = 0L;
                            private final String storeName$1;
                            private final LongRef ttl$1;

                            public final Tuple3<String, String, Object> apply() {
                                return new Tuple3((Object)"The ttl values requested for %s is %d, which is less than 1000 (minimum), using 1000 instead", (Object)this.storeName$1, (Object)BoxesRunTime.boxToLong((long)this.ttl$1.elem));
                            }
                            {
                                this.storeName$1 = storeName$1;
                                this.ttl$1 = ttl$1;
                            }
                        });
                        ttl.elem = 1000L;
                    }
                    ttl.elem /= 1000L;
                } else {
                    this.warn((Function0<Object>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Non-positive TTL for RocksDB implies infinite TTL for the data. More Info -https://github.com/facebook/rocksdb/wiki/Time-to-Live";
                        }
                    });
                }
                useTTL = true;
                if (!isLoggedStore) break block10;
                this.warn((Function0<Object>)new Serializable(storeName){
                    public static final long serialVersionUID = 0L;
                    private final String storeName$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("%s is a TTL based store, changelog is not supported for TTL based stores, use at your own discretion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.storeName$1}));
                    }
                    {
                        this.storeName$1 = storeName$1;
                    }
                });
            }
        }
        try {
            RocksDB rocksDB;
            if (useTTL) {
                this.info((Function0<Object>)new Serializable(ttl){
                    public static final long serialVersionUID = 0L;
                    private final LongRef ttl$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Opening RocksDB store with TTL value: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.ttl$1.elem)}));
                    }
                    {
                        this.ttl$1 = ttl$1;
                    }
                });
                rocksDB = TtlDB.open((Options)options, (String)dir.toString(), (int)((int)ttl.elem), (boolean)false);
            } else {
                rocksDB = RocksDB.open((Options)options, (String)dir.toString());
            }
            return rocksDB;
        }
        catch (RocksDBException rocksDBException) {
            throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("Error opening RocksDB store %s at location %s, received the following exception from RocksDB %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{storeName, dir.toString(), rocksDBException})));
        }
        catch (NumberFormatException numberFormatException) {
            throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("rocksdb.ttl.ms configuration is not a number, value found %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{storeConfig.get((Object)"rocksdb.ttl.ms")})));
        }
    }

    public WriteOptions $lessinit$greater$default$6() {
        return new WriteOptions();
    }

    public FlushOptions $lessinit$greater$default$7() {
        return new FlushOptions();
    }

    public KeyValueStoreMetrics $lessinit$greater$default$8() {
        return new KeyValueStoreMetrics(KeyValueStoreMetrics$.MODULE$.$lessinit$greater$default$1(), KeyValueStoreMetrics$.MODULE$.$lessinit$greater$default$2());
    }

    private RocksDbKeyValueStore$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

