/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv;

import org.apache.samza.config.Config;
import org.apache.samza.container.SamzaContainerContext;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.Options;
import org.rocksdb.TableFormatConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDbOptionsHelper {
    private static final Logger log = LoggerFactory.getLogger(RocksDbOptionsHelper.class);
    private static final String ROCKSDB_COMPRESSION = "rocksdb.compression";
    private static final String ROCKSDB_BLOCK_SIZE_BYTES = "rocksdb.block.size.bytes";
    private static final String ROCKSDB_COMPACTION_STYLE = "rocksdb.compaction.style";
    private static final String ROCKSDB_NUM_WRITE_BUFFERS = "rocksdb.num.write.buffers";
    private static final String ROCKSDB_MAX_LOG_FILE_SIZE_BYTES = "rocksdb.max.log.file.size.bytes";
    private static final String ROCKSDB_KEEP_LOG_FILE_NUM = "rocksdb.keep.log.file.num";

    public static Options options(Config storeConfig, SamzaContainerContext containerContext) {
        String compactionStyleInConfig;
        String compressionInConfig;
        Options options = new Options();
        Long writeBufSize = storeConfig.getLong("container.write.buffer.size.bytes", 0x2000000L);
        int numTasks = containerContext.taskNames.size();
        options.setWriteBufferSize((long)((int)(writeBufSize / (long)numTasks)));
        CompressionType compressionType = CompressionType.SNAPPY_COMPRESSION;
        switch (compressionInConfig = storeConfig.get(ROCKSDB_COMPRESSION, "snappy")) {
            case "snappy": {
                compressionType = CompressionType.SNAPPY_COMPRESSION;
                break;
            }
            case "bzip2": {
                compressionType = CompressionType.BZLIB2_COMPRESSION;
                break;
            }
            case "zlib": {
                compressionType = CompressionType.ZLIB_COMPRESSION;
                break;
            }
            case "lz4": {
                compressionType = CompressionType.LZ4_COMPRESSION;
                break;
            }
            case "lz4hc": {
                compressionType = CompressionType.LZ4HC_COMPRESSION;
                break;
            }
            case "none": {
                compressionType = CompressionType.NO_COMPRESSION;
                break;
            }
            default: {
                log.warn("Unknown rocksdb.compression codec " + compressionInConfig + ", overwriting to " + compressionType.name());
            }
        }
        options.setCompressionType(compressionType);
        Long cacheSize = storeConfig.getLong("container.cache.size.bytes", 0x6400000L);
        Long cacheSizePerContainer = cacheSize / (long)numTasks;
        int blockSize = storeConfig.getInt(ROCKSDB_BLOCK_SIZE_BYTES, 4096);
        BlockBasedTableConfig tableOptions = new BlockBasedTableConfig();
        tableOptions.setBlockCacheSize(cacheSizePerContainer.longValue()).setBlockSize((long)blockSize);
        options.setTableFormatConfig((TableFormatConfig)tableOptions);
        CompactionStyle compactionStyle = CompactionStyle.UNIVERSAL;
        switch (compactionStyleInConfig = storeConfig.get(ROCKSDB_COMPACTION_STYLE, "universal")) {
            case "universal": {
                compactionStyle = CompactionStyle.UNIVERSAL;
                break;
            }
            case "fifo": {
                compactionStyle = CompactionStyle.FIFO;
                break;
            }
            case "level": {
                compactionStyle = CompactionStyle.LEVEL;
                break;
            }
            default: {
                log.warn("Unknown rocksdb.compaction.style " + compactionStyleInConfig + ", overwriting to " + compactionStyle.name());
            }
        }
        options.setCompactionStyle(compactionStyle);
        options.setMaxWriteBufferNumber(storeConfig.getInt(ROCKSDB_NUM_WRITE_BUFFERS, 3));
        options.setCreateIfMissing(true);
        options.setErrorIfExists(false);
        options.setMaxLogFileSize(storeConfig.getLong(ROCKSDB_MAX_LOG_FILE_SIZE_BYTES, 0x4000000L));
        options.setKeepLogFileNum(storeConfig.getLong(ROCKSDB_KEEP_LOG_FILE_NUM, 2L));
        return options;
    }
}

