/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.scp.helpers;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.scp.ScpFileOpener;
import org.apache.sshd.common.scp.ScpTargetStreamResolver;
import org.apache.sshd.common.scp.ScpTimestamp;
import org.apache.sshd.common.scp.helpers.DefaultScpFileOpener;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class LocalFileScpTargetStreamResolver
extends AbstractLoggingBean
implements ScpTargetStreamResolver {
    protected final Path path;
    protected final ScpFileOpener opener;
    protected final Boolean status;
    private Path file;

    public LocalFileScpTargetStreamResolver(Path path, ScpFileOpener opener) throws IOException {
        LinkOption[] linkOptions = IoUtils.getLinkOptions((boolean)true);
        this.status = IoUtils.checkFileExists((Path)path, (LinkOption[])linkOptions);
        if (this.status == null) {
            throw new AccessDeniedException("Receive target file path existence status cannot be determined: " + path);
        }
        this.path = path;
        this.opener = opener == null ? DefaultScpFileOpener.INSTANCE : opener;
    }

    @Override
    public OutputStream resolveTargetStream(Session session, String name, long length, Set<PosixFilePermission> perms, OpenOption ... options) throws IOException {
        if (this.file != null) {
            throw new StreamCorruptedException("resolveTargetStream(" + name + ")[" + perms + "] already resolved: " + this.file);
        }
        LinkOption[] linkOptions = IoUtils.getLinkOptions((boolean)true);
        if (this.status.booleanValue() && Files.isDirectory(this.path, linkOptions)) {
            String localName = name.replace('/', File.separatorChar);
            this.file = this.path.resolve(localName);
        } else if (this.status.booleanValue() && Files.isRegularFile(this.path, linkOptions)) {
            this.file = this.path;
        } else if (!this.status.booleanValue()) {
            Path parent = this.path.getParent();
            Boolean parentStatus = IoUtils.checkFileExists((Path)parent, (LinkOption[])linkOptions);
            if (parentStatus == null) {
                throw new AccessDeniedException("Receive file parent (" + parent + ") existence status cannot be determined for " + this.path);
            }
            if (parentStatus.booleanValue() && Files.isDirectory(parent, linkOptions)) {
                this.file = this.path;
            }
        }
        if (this.file == null) {
            throw new IOException("Can not write to " + this.path);
        }
        Boolean fileStatus = IoUtils.checkFileExists((Path)this.file, (LinkOption[])linkOptions);
        if (fileStatus == null) {
            throw new AccessDeniedException("Receive file existence status cannot be determined: " + this.file);
        }
        if (fileStatus.booleanValue()) {
            if (Files.isDirectory(this.file, linkOptions)) {
                throw new IOException("File is a directory: " + this.file);
            }
            if (!Files.isWritable(this.file)) {
                throw new IOException("Can not write to file: " + this.file);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("resolveTargetStream(" + name + "): " + this.file);
        }
        return this.opener.openWrite(session, this.file, options);
    }

    @Override
    public Path getEventListenerFilePath() {
        if (this.file == null) {
            return this.path;
        }
        return this.file;
    }

    @Override
    public void postProcessReceivedData(String name, boolean preserve, Set<PosixFilePermission> perms, ScpTimestamp time) throws IOException {
        if (this.file == null) {
            throw new StreamCorruptedException("postProcessReceivedData(" + name + ")[" + perms + "] No currently resolved data");
        }
        if (preserve) {
            this.updateFileProperties(name, this.file, perms, time);
        }
    }

    protected void updateFileProperties(String name, Path path, Set<PosixFilePermission> perms, ScpTimestamp time) throws IOException {
        boolean traceEnabled = this.log.isTraceEnabled();
        if (traceEnabled) {
            this.log.trace("updateFileProperties(" + name + ")[" + path + "] permissions: " + perms);
        }
        IoUtils.setPermissions((Path)path, perms);
        if (time != null) {
            BasicFileAttributeView view = Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]);
            FileTime lastModified = FileTime.from(time.getLastModifiedTime(), TimeUnit.MILLISECONDS);
            FileTime lastAccess = FileTime.from(time.getLastAccessTime(), TimeUnit.MILLISECONDS);
            if (traceEnabled) {
                this.log.trace("updateFileProperties(" + name + ")[" + path + "] last-modified=" + lastModified + ", last-access=" + lastAccess);
            }
            view.setTimes(lastModified, lastAccess, null);
        }
    }

    public String toString() {
        return String.valueOf(this.getEventListenerFilePath());
    }
}

