/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.expr;

import com.healthmarketscience.jackcess.expr.EvalContext;
import com.healthmarketscience.jackcess.expr.EvalException;
import com.healthmarketscience.jackcess.expr.Function;
import com.healthmarketscience.jackcess.expr.FunctionLookup;
import com.healthmarketscience.jackcess.expr.LocaleContext;
import com.healthmarketscience.jackcess.expr.NumericConfig;
import com.healthmarketscience.jackcess.expr.TemporalConfig;
import com.healthmarketscience.jackcess.expr.Value;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.expr.DefaultDateFunctions;
import com.healthmarketscience.jackcess.impl.expr.DefaultFinancialFunctions;
import com.healthmarketscience.jackcess.impl.expr.DefaultNumberFunctions;
import com.healthmarketscience.jackcess.impl.expr.DefaultTextFunctions;
import com.healthmarketscience.jackcess.impl.expr.FormatUtil;
import com.healthmarketscience.jackcess.impl.expr.FunctionSupport;
import com.healthmarketscience.jackcess.impl.expr.NumberFormatter;
import com.healthmarketscience.jackcess.impl.expr.ValueSupport;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;

public class DefaultFunctions {
    private static final Map<String, Function> FUNCS = new HashMap<String, Function>();
    public static final FunctionLookup LOOKUP;
    public static final Function IIF;
    public static final Function HEX;
    public static final Function NZ;
    public static final Function CHOOSE;
    public static final Function SWITCH;
    public static final Function OCT;
    public static final Function CBOOL;
    public static final Function CBYTE;
    public static final Function CCUR;
    public static final Function CDATE;
    public static final Function CDBL;
    public static final Function CDEC;
    public static final Function CINT;
    public static final Function CLNG;
    public static final Function CSNG;
    public static final Function CSTR;
    public static final Function CVAR;
    public static final Function ISNULL;
    public static final Function ISDATE;
    public static final Function ISNUMERIC;
    public static final Function FORMATNUMBER;
    public static final Function FORMATPERCENT;
    public static final Function FORMATCURRENCY;
    public static final Function FORMATDATETIME;
    public static final Function VARTYPE;
    public static final Function TYPENAME;
    public static final Function VAL;

    private DefaultFunctions() {
    }

    private static boolean stringIsNumeric(LocaleContext ctx, Value param) {
        return DefaultFunctions.maybeGetAsBigDecimal(ctx, param) != null;
    }

    static BigDecimal maybeGetAsBigDecimal(LocaleContext ctx, Value param) {
        try {
            return param.getAsBigDecimal(ctx);
        }
        catch (EvalException evalException) {
            return null;
        }
    }

    private static boolean stringIsTemporal(EvalContext ctx, Value param) {
        return DefaultFunctions.maybeGetAsDateTimeValue(ctx, param) != null;
    }

    static Value maybeGetAsDateTimeValue(LocaleContext ctx, Value param) {
        try {
            return param.getAsDateTimeValue(ctx);
        }
        catch (EvalException evalException) {
            return null;
        }
    }

    private static boolean getOptionalTriStateBoolean(EvalContext ctx, Value[] params, int idx, boolean defValue) {
        boolean bv = defValue;
        if (params.length > idx) {
            int val = params[idx].getAsLongInt(ctx);
            switch (val) {
                case 0: {
                    bv = false;
                    break;
                }
                case -1: {
                    bv = true;
                    break;
                }
                case -2: {
                    bv = defValue;
                    break;
                }
                default: {
                    throw new EvalException("Unsupported tri-state boolean value " + val);
                }
            }
        }
        return bv;
    }

    private static Value formatNumber(EvalContext ctx, Value[] params, FormatUtil.NumPatternType numPatType) {
        Value param1 = params[0];
        if (param1.isNull()) {
            return ValueSupport.NULL_VAL;
        }
        NumericConfig cfg = ctx.getNumericConfig();
        int numDecDigits = FunctionSupport.getOptionalIntParam(ctx, params, 1, cfg.getNumDecimalDigits(), -1);
        boolean incLeadDigit = DefaultFunctions.getOptionalTriStateBoolean(ctx, params, 2, cfg.includeLeadingDigit());
        boolean defNegParens = numPatType.useParensForNegatives(cfg);
        boolean negParens = DefaultFunctions.getOptionalTriStateBoolean(ctx, params, 3, defNegParens);
        int defNumGroupDigits = cfg.getNumGroupingDigits();
        boolean groupDigits = DefaultFunctions.getOptionalTriStateBoolean(ctx, params, 4, defNumGroupDigits > 0);
        int numGroupDigits = groupDigits ? defNumGroupDigits : 0;
        String fmtStr = FormatUtil.createNumberFormatPattern(numPatType, numDecDigits, incLeadDigit, negParens, numGroupDigits);
        DecimalFormat df = ctx.createDecimalFormat(fmtStr);
        return ValueSupport.toValue(df.format(param1.getAsBigDecimal(ctx)));
    }

    static Function registerFunc(Function func) {
        DefaultFunctions.registerFunc(func.getName(), func);
        return func;
    }

    static Function registerStringFunc(Function func) {
        DefaultFunctions.registerFunc(func.getName(), func);
        DefaultFunctions.registerFunc(new FunctionSupport.StringFuncWrapper(func));
        return func;
    }

    private static void registerFunc(String fname, Function func) {
        String lookupFname = DatabaseImpl.toLookupName(fname);
        if (FUNCS.put(lookupFname, func) != null) {
            throw new IllegalStateException("Duplicate function " + fname);
        }
    }

    static {
        DefaultTextFunctions.init();
        DefaultNumberFunctions.init();
        DefaultDateFunctions.init();
        DefaultFinancialFunctions.init();
        LOOKUP = new FunctionLookup(){

            @Override
            public Function getFunction(String name) {
                return (Function)FUNCS.get(DatabaseImpl.toLookupName(name));
            }
        };
        IIF = DefaultFunctions.registerFunc(new FunctionSupport.Func3("IIf"){

            @Override
            protected Value eval3(EvalContext ctx, Value param1, Value param2, Value param3) {
                return !param1.isNull() && param1.getAsBoolean(ctx) ? param2 : param3;
            }
        });
        HEX = DefaultFunctions.registerStringFunc(new FunctionSupport.Func1NullIsNull("Hex"){

            @Override
            protected Value eval1(EvalContext ctx, Value param1) {
                if (param1.getType().isString() && param1.getAsString(ctx).length() == 0) {
                    return ValueSupport.ZERO_VAL;
                }
                int lv = param1.getAsLongInt(ctx);
                return ValueSupport.toValue(Integer.toHexString(lv).toUpperCase());
            }
        });
        NZ = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("Nz", 1, 2){

            @Override
            protected Value evalVar(EvalContext ctx, Value[] params) {
                Value param1 = params[0];
                if (!param1.isNull()) {
                    return param1;
                }
                if (params.length > 1) {
                    return params[1];
                }
                Value.Type resultType = ctx.getResultType();
                return resultType == null || resultType.isString() ? ValueSupport.EMPTY_STR_VAL : ValueSupport.ZERO_VAL;
            }
        });
        CHOOSE = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("Choose", 1, Integer.MAX_VALUE){

            @Override
            protected Value evalVar(EvalContext ctx, Value[] params) {
                Value param1 = params[0];
                int idx = param1.getAsLongInt(ctx);
                if (idx < 1 || idx >= params.length) {
                    return ValueSupport.NULL_VAL;
                }
                return params[idx];
            }
        });
        SWITCH = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("Switch"){

            @Override
            protected Value evalVar(EvalContext ctx, Value[] params) {
                if (params.length % 2 != 0) {
                    throw new EvalException("Odd number of parameters");
                }
                for (int i = 0; i < params.length; i += 2) {
                    if (!params[i].getAsBoolean(ctx)) continue;
                    return params[i + 1];
                }
                return ValueSupport.NULL_VAL;
            }
        });
        OCT = DefaultFunctions.registerStringFunc(new FunctionSupport.Func1NullIsNull("Oct"){

            @Override
            protected Value eval1(EvalContext ctx, Value param1) {
                if (param1.getType().isString() && param1.getAsString(ctx).length() == 0) {
                    return ValueSupport.ZERO_VAL;
                }
                int lv = param1.getAsLongInt(ctx);
                return ValueSupport.toValue(Integer.toOctalString(lv));
            }
        });
        CBOOL = DefaultFunctions.registerFunc(new FunctionSupport.Func1("CBool"){

            @Override
            protected Value eval1(EvalContext ctx, Value param1) {
                boolean b = param1.getAsBoolean(ctx);
                return ValueSupport.toValue(b);
            }
        });
        CBYTE = DefaultFunctions.registerFunc(new FunctionSupport.Func1("CByte"){

            @Override
            protected Value eval1(EvalContext ctx, Value param1) {
                int lv = param1.getAsLongInt(ctx);
                if (lv < 0 || lv > 255) {
                    throw new EvalException("Byte code '" + lv + "' out of range ");
                }
                return ValueSupport.toValue(lv);
            }
        });
        CCUR = DefaultFunctions.registerFunc(new FunctionSupport.Func1("CCur"){

            @Override
            protected Value eval1(EvalContext ctx, Value param1) {
                BigDecimal bd = param1.getAsBigDecimal(ctx);
                bd = bd.setScale(4, NumberFormatter.ROUND_MODE);
                return ValueSupport.toValue(bd);
            }
        });
        CDATE = DefaultFunctions.registerFunc(new FunctionSupport.Func1("CDate"){

            @Override
            protected Value eval1(EvalContext ctx, Value param1) {
                return param1.getAsDateTimeValue(ctx);
            }
        });
        DefaultFunctions.registerFunc("CVDate", CDATE);
        CDBL = DefaultFunctions.registerFunc(new FunctionSupport.Func1("CDbl"){

            @Override
            protected Value eval1(EvalContext ctx, Value param1) {
                Double dv = param1.getAsDouble(ctx);
                return ValueSupport.toValue(dv);
            }
        });
        CDEC = DefaultFunctions.registerFunc(new FunctionSupport.Func1("CDec"){

            @Override
            protected Value eval1(EvalContext ctx, Value param1) {
                BigDecimal bd = param1.getAsBigDecimal(ctx);
                return ValueSupport.toValue(bd);
            }
        });
        CINT = DefaultFunctions.registerFunc(new FunctionSupport.Func1("CInt"){

            @Override
            protected Value eval1(EvalContext ctx, Value param1) {
                int lv = param1.getAsLongInt(ctx);
                if (lv < Short.MIN_VALUE || lv > Short.MAX_VALUE) {
                    throw new EvalException("Int value '" + lv + "' out of range ");
                }
                return ValueSupport.toValue(lv);
            }
        });
        CLNG = DefaultFunctions.registerFunc(new FunctionSupport.Func1("CLng"){

            @Override
            protected Value eval1(EvalContext ctx, Value param1) {
                int lv = param1.getAsLongInt(ctx);
                return ValueSupport.toValue(lv);
            }
        });
        CSNG = DefaultFunctions.registerFunc(new FunctionSupport.Func1("CSng"){

            @Override
            protected Value eval1(EvalContext ctx, Value param1) {
                Double dv = param1.getAsDouble(ctx);
                if (dv < (double)1.4E-45f || dv > 3.4028234663852886E38) {
                    throw new EvalException("Single value '" + dv + "' out of range ");
                }
                return ValueSupport.toValue(dv.floatValue());
            }
        });
        CSTR = DefaultFunctions.registerFunc(new FunctionSupport.Func1("CStr"){

            @Override
            protected Value eval1(EvalContext ctx, Value param1) {
                return ValueSupport.toValue(param1.getAsString(ctx));
            }
        });
        CVAR = DefaultFunctions.registerFunc(new FunctionSupport.Func1("CVar"){

            @Override
            protected Value eval1(EvalContext ctx, Value param1) {
                return param1;
            }
        });
        ISNULL = DefaultFunctions.registerFunc(new FunctionSupport.Func1("IsNull"){

            @Override
            protected Value eval1(EvalContext ctx, Value param1) {
                return ValueSupport.toValue(param1.isNull());
            }
        });
        ISDATE = DefaultFunctions.registerFunc(new FunctionSupport.Func1("IsDate"){

            @Override
            protected Value eval1(EvalContext ctx, Value param1) {
                if (param1.getType().isTemporal()) {
                    return ValueSupport.TRUE_VAL;
                }
                if (param1.getType().isString() && !DefaultFunctions.stringIsNumeric(ctx, param1) && DefaultFunctions.stringIsTemporal(ctx, param1)) {
                    return ValueSupport.TRUE_VAL;
                }
                return ValueSupport.FALSE_VAL;
            }
        });
        ISNUMERIC = DefaultFunctions.registerFunc(new FunctionSupport.Func1("IsNumeric"){

            @Override
            protected Value eval1(EvalContext ctx, Value param1) {
                if (param1.getType().isNumeric()) {
                    return ValueSupport.TRUE_VAL;
                }
                if (param1.getType().isString() && DefaultFunctions.stringIsNumeric(ctx, param1)) {
                    return ValueSupport.TRUE_VAL;
                }
                return ValueSupport.FALSE_VAL;
            }
        });
        FORMATNUMBER = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("FormatNumber", 1, 6){

            @Override
            protected Value evalVar(EvalContext ctx, Value[] params) {
                return DefaultFunctions.formatNumber(ctx, params, FormatUtil.NumPatternType.GENERAL);
            }
        });
        FORMATPERCENT = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("FormatPercent", 1, 6){

            @Override
            protected Value evalVar(EvalContext ctx, Value[] params) {
                return DefaultFunctions.formatNumber(ctx, params, FormatUtil.NumPatternType.PERCENT);
            }
        });
        FORMATCURRENCY = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("FormatCurrency", 1, 6){

            @Override
            protected Value evalVar(EvalContext ctx, Value[] params) {
                return DefaultFunctions.formatNumber(ctx, params, FormatUtil.NumPatternType.CURRENCY);
            }
        });
        FORMATDATETIME = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("FormatDateTime", 1, 2){

            @Override
            protected Value evalVar(EvalContext ctx, Value[] params) {
                Value param1 = params[0];
                if (param1.isNull()) {
                    return ValueSupport.NULL_VAL;
                }
                LocalDateTime ldt = param1.getAsLocalDateTime(ctx);
                int fmtType = FunctionSupport.getOptionalIntParam(ctx, params, 1, 0);
                TemporalConfig.Type tempType = null;
                block0 : switch (fmtType) {
                    case 0: {
                        Value.Type valType = ValueSupport.getDateTimeType(ldt);
                        switch (valType) {
                            case DATE: {
                                tempType = TemporalConfig.Type.SHORT_DATE;
                                break block0;
                            }
                            case TIME: {
                                tempType = TemporalConfig.Type.LONG_TIME;
                                break block0;
                            }
                        }
                        tempType = TemporalConfig.Type.GENERAL_DATE;
                        break;
                    }
                    case 1: {
                        tempType = TemporalConfig.Type.LONG_DATE;
                        break;
                    }
                    case 2: {
                        tempType = TemporalConfig.Type.SHORT_DATE;
                        break;
                    }
                    case 3: {
                        tempType = TemporalConfig.Type.LONG_TIME;
                        break;
                    }
                    case 4: {
                        tempType = TemporalConfig.Type.SHORT_TIME;
                        break;
                    }
                    default: {
                        throw new EvalException("Unknown format " + fmtType);
                    }
                }
                DateTimeFormatter dtf = ctx.createDateFormatter(ctx.getTemporalConfig().getDateTimeFormat(tempType));
                return ValueSupport.toValue(dtf.format(ldt));
            }
        });
        VARTYPE = DefaultFunctions.registerFunc(new FunctionSupport.Func1("VarType"){

            @Override
            protected Value eval1(EvalContext ctx, Value param1) {
                Value.Type type = param1.getType();
                int vType = 0;
                switch (type) {
                    case NULL: {
                        vType = 1;
                        break;
                    }
                    case STRING: {
                        vType = 8;
                        break;
                    }
                    case DATE: 
                    case TIME: 
                    case DATE_TIME: {
                        vType = 7;
                        break;
                    }
                    case LONG: {
                        vType = 3;
                        break;
                    }
                    case DOUBLE: {
                        vType = 5;
                        break;
                    }
                    case BIG_DEC: {
                        vType = 14;
                        break;
                    }
                    default: {
                        throw new EvalException("Unknown type " + (Object)((Object)type));
                    }
                }
                return ValueSupport.toValue(vType);
            }
        });
        TYPENAME = DefaultFunctions.registerFunc(new FunctionSupport.Func1("TypeName"){

            @Override
            protected Value eval1(EvalContext ctx, Value param1) {
                Value.Type type = param1.getType();
                String tName = null;
                switch (type) {
                    case NULL: {
                        tName = "Null";
                        break;
                    }
                    case STRING: {
                        tName = "String";
                        break;
                    }
                    case DATE: 
                    case TIME: 
                    case DATE_TIME: {
                        tName = "Date";
                        break;
                    }
                    case LONG: {
                        tName = "Long";
                        break;
                    }
                    case DOUBLE: {
                        tName = "Double";
                        break;
                    }
                    case BIG_DEC: {
                        tName = "Decimal";
                        break;
                    }
                    default: {
                        throw new EvalException("Unknown type " + (Object)((Object)type));
                    }
                }
                return ValueSupport.toValue(tName);
            }
        });
        VAL = DefaultFunctions.registerStringFunc(new FunctionSupport.Func1NullIsNull("Val"){

            @Override
            protected Value eval1(EvalContext ctx, Value param1) {
                String str = ValueSupport.WHITESPACE_PAT.matcher(param1.getAsString(ctx)).replaceAll("");
                if (str.length() == 0) {
                    return ValueSupport.ZERO_D_VAL;
                }
                Matcher m3 = null;
                if (str.charAt(0) == '&') {
                    BigInteger bi = null;
                    m3 = ValueSupport.HEX_PAT.matcher(str);
                    if (m3.find()) {
                        bi = ValueSupport.parseIntegerString(m3.group(), 16);
                    } else {
                        m3 = ValueSupport.OCTAL_PAT.matcher(str);
                        if (m3.find()) {
                            bi = ValueSupport.parseIntegerString(m3.group(), 8);
                        }
                    }
                    if (bi != null) {
                        int iVal = bi.bitLength() <= 16 ? bi.shortValue() : bi.intValue();
                        return ValueSupport.toValue((double)iVal);
                    }
                } else {
                    m3 = ValueSupport.NUMBER_PAT.matcher(str);
                    if (m3.find()) {
                        BigDecimal bd = new BigDecimal(m3.group());
                        return ValueSupport.toValue(bd.doubleValue());
                    }
                }
                return ValueSupport.ZERO_D_VAL;
            }
        });
    }
}

