/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.MLNumericArray;
import java.nio.ByteBuffer;

public class MLDouble
extends MLNumericArray<Double> {
    public MLDouble(String name, int[] dims, int type, int attributes) {
        super(name, dims, type, attributes);
    }

    public MLDouble(String name, int[] dims) {
        super(name, dims, 6, 0);
    }

    public MLDouble(String name, Double[] vals, int m3) {
        super(name, 6, (Number[])vals, m3);
    }

    public MLDouble(String name, double[][] vals) {
        this(name, MLDouble.double2DToDouble(vals), vals.length);
    }

    public MLDouble(String name, double[] vals, int m3) {
        this(name, MLDouble.castToDouble(vals), m3);
    }

    public double[][] getArray() {
        double[][] result = new double[this.getM()][];
        for (int m3 = 0; m3 < this.getM(); ++m3) {
            result[m3] = new double[this.getN()];
            for (int n = 0; n < this.getN(); ++n) {
                result[m3][n] = (Double)this.getReal(m3, n);
            }
        }
        return result;
    }

    private static Double[] castToDouble(double[] d) {
        Double[] dest = new Double[d.length];
        for (int i = 0; i < d.length; ++i) {
            dest[i] = d[i];
        }
        return dest;
    }

    private static Double[] double2DToDouble(double[][] dd) {
        Double[] d = new Double[dd.length * dd[0].length];
        for (int n = 0; n < dd[0].length; ++n) {
            for (int m3 = 0; m3 < dd.length; ++m3) {
                d[m3 + n * dd.length] = dd[m3][n];
            }
        }
        return d;
    }

    @Override
    public int getBytesAllocated() {
        return 8;
    }

    @Override
    public Double buldFromBytes(byte[] bytes) {
        if (bytes.length != this.getBytesAllocated()) {
            throw new IllegalArgumentException("To build from byte array I need array of size: " + this.getBytesAllocated());
        }
        return ByteBuffer.wrap(bytes).getDouble();
    }

    @Override
    public byte[] getByteArray(Double value) {
        int byteAllocated = this.getBytesAllocated();
        ByteBuffer buff = ByteBuffer.allocate(byteAllocated);
        buff.putDouble(value);
        return buff.array();
    }

    @Override
    public Class<Double> getStorageClazz() {
        return Double.class;
    }
}

