/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.jhighlight.fastutil.chars;

import com.uwyn.jhighlight.fastutil.Hash;
import com.uwyn.jhighlight.fastutil.HashCommon;
import com.uwyn.jhighlight.fastutil.booleans.BooleanArrays;
import com.uwyn.jhighlight.fastutil.chars.AbstractChar2ObjectMap;
import com.uwyn.jhighlight.fastutil.chars.AbstractCharSet;
import com.uwyn.jhighlight.fastutil.chars.Char2ObjectMap;
import com.uwyn.jhighlight.fastutil.chars.CharArrayList;
import com.uwyn.jhighlight.fastutil.chars.CharIterator;
import com.uwyn.jhighlight.fastutil.chars.CharSet;
import com.uwyn.jhighlight.fastutil.objects.AbstractObjectCollection;
import com.uwyn.jhighlight.fastutil.objects.AbstractObjectSet;
import com.uwyn.jhighlight.fastutil.objects.ObjectArrays;
import com.uwyn.jhighlight.fastutil.objects.ObjectCollection;
import com.uwyn.jhighlight.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

public class Char2ObjectOpenHashMap<V>
extends AbstractChar2ObjectMap<V>
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient char[] key;
    protected transient V[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Char2ObjectMap.FastEntrySet<V> entries;
    protected volatile transient CharSet keys;
    protected volatile transient ObjectCollection<V> values;

    public Char2ObjectOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new char[this.n];
        this.value = new Object[this.n];
        this.used = new boolean[this.n];
    }

    public Char2ObjectOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Char2ObjectOpenHashMap() {
        this(16, 0.75f);
    }

    public Char2ObjectOpenHashMap(Map<? extends Character, ? extends V> m3, float f) {
        this(m3.size(), f);
        this.putAll(m3);
    }

    public Char2ObjectOpenHashMap(Map<? extends Character, ? extends V> m3) {
        this(m3, 0.75f);
    }

    public Char2ObjectOpenHashMap(Char2ObjectMap<V> m3, float f) {
        this(m3.size(), f);
        this.putAll(m3);
    }

    public Char2ObjectOpenHashMap(Char2ObjectMap<V> m3) {
        this(m3, 0.75f);
    }

    public Char2ObjectOpenHashMap(char[] k, V[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Char2ObjectOpenHashMap(char[] k, V[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public V put(char k, V v) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                V oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return (V)this.defRetValue;
    }

    @Override
    public V put(Character ok, V ov) {
        V v = ov;
        char k = ok.charValue();
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                V oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return (V)this.defRetValue;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(this.key[pos] ^ this.mask) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
        }
        this.used[last] = false;
        this.value[last] = null;
        return last;
    }

    @Override
    public V remove(char k) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                V v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return (V)this.defRetValue;
    }

    @Override
    public V remove(Object ok) {
        char k = ((Character)ok).charValue();
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                V v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return (V)this.defRetValue;
    }

    public V get(Character ok) {
        char k = ok.charValue();
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return (V)this.defRetValue;
    }

    @Override
    public V get(char k) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return (V)this.defRetValue;
    }

    @Override
    public boolean containsKey(char k) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object v) {
        V[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || !(value[i] == null ? v == null : value[i].equals(v))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        ObjectArrays.fill(this.value, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public Char2ObjectMap.FastEntrySet<V> char2ObjectEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public CharSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ObjectCollection<V> values() {
        if (this.values == null) {
            this.values = new AbstractObjectCollection<V>(){

                @Override
                public ObjectIterator<V> iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Char2ObjectOpenHashMap.this.size;
                }

                @Override
                public boolean contains(Object v) {
                    return Char2ObjectOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Char2ObjectOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        char[] key = this.key;
        V[] value = this.value;
        int mask = newN - 1;
        char[] newKey = new char[newN];
        Object[] newValue = new Object[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            char k = key[i];
            int pos = HashCommon.murmurHash3(k ^ mask) & mask;
            while (newUsed[pos]) {
                pos = pos + 1 & mask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            ++i;
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
    }

    public Char2ObjectOpenHashMap<V> clone() {
        Char2ObjectOpenHashMap c;
        try {
            c = (Char2ObjectOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (char[])this.key.clone();
        c.value = (Object[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = this.key[i];
            if (this != this.value[i]) {
                t ^= this.value[i] == null ? 0 : this.value[i].hashCode();
            }
            h2 += t;
            ++i;
        }
        return h2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        char[] key = this.key;
        V[] value = this.value;
        MapIterator i = new MapIterator();
        s2.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s2.writeChar(key[e]);
            s2.writeObject(value[e]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new char[this.n];
        char[] key = this.key;
        this.value = new Object[this.n];
        Object[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            char k = s2.readChar();
            Object v = s2.readObject();
            pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements ObjectIterator<V> {
        @Override
        public V next() {
            return Char2ObjectOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractCharSet {
        private KeySet() {
        }

        @Override
        public CharIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Char2ObjectOpenHashMap.this.size;
        }

        @Override
        public boolean contains(char k) {
            return Char2ObjectOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(char k) {
            int oldSize = Char2ObjectOpenHashMap.this.size;
            Char2ObjectOpenHashMap.this.remove(k);
            return Char2ObjectOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Char2ObjectOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements CharIterator {
        @Override
        public char nextChar() {
            return Char2ObjectOpenHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Character next() {
            return Character.valueOf(Char2ObjectOpenHashMap.this.key[this.nextEntry()]);
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Char2ObjectMap.Entry<V>>
    implements Char2ObjectMap.FastEntrySet<V> {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Char2ObjectMap.Entry<V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Char2ObjectMap.Entry<V>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            char k = ((Character)e.getKey()).charValue();
            int pos = HashCommon.murmurHash3(k ^ Char2ObjectOpenHashMap.this.mask) & Char2ObjectOpenHashMap.this.mask;
            while (Char2ObjectOpenHashMap.this.used[pos]) {
                if (Char2ObjectOpenHashMap.this.key[pos] == k) {
                    return Char2ObjectOpenHashMap.this.value[pos] == null ? e.getValue() == null : Char2ObjectOpenHashMap.this.value[pos].equals(e.getValue());
                }
                pos = pos + 1 & Char2ObjectOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            char k = ((Character)e.getKey()).charValue();
            int pos = HashCommon.murmurHash3(k ^ Char2ObjectOpenHashMap.this.mask) & Char2ObjectOpenHashMap.this.mask;
            while (Char2ObjectOpenHashMap.this.used[pos]) {
                if (Char2ObjectOpenHashMap.this.key[pos] == k) {
                    Char2ObjectOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Char2ObjectOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Char2ObjectOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Char2ObjectOpenHashMap.this.clear();
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Char2ObjectMap.Entry<V>> {
        final AbstractChar2ObjectMap.BasicEntry<V> entry;

        private FastEntryIterator() {
            this.entry = new AbstractChar2ObjectMap.BasicEntry<Object>('\u0000', null);
        }

        @Override
        public AbstractChar2ObjectMap.BasicEntry<V> next() {
            int e = this.nextEntry();
            this.entry.key = Char2ObjectOpenHashMap.this.key[e];
            this.entry.value = Char2ObjectOpenHashMap.this.value[e];
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Char2ObjectMap.Entry<V>> {
        private MapEntry entry;

        private EntryIterator() {
        }

        @Override
        public Char2ObjectMap.Entry<V> next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;
        CharArrayList wrapped;

        private MapIterator() {
            this.pos = Char2ObjectOpenHashMap.this.n;
            this.last = -1;
            this.c = Char2ObjectOpenHashMap.this.size;
            boolean[] used = Char2ObjectOpenHashMap.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.pos < 0) {
                this.last = --this.pos;
                char k = this.wrapped.getChar(-this.pos - 2);
                int pos = HashCommon.murmurHash3(k ^ Char2ObjectOpenHashMap.this.mask) & Char2ObjectOpenHashMap.this.mask;
                while (Char2ObjectOpenHashMap.this.used[pos]) {
                    if (Char2ObjectOpenHashMap.this.key[pos] == k) {
                        return pos;
                    }
                    pos = pos + 1 & Char2ObjectOpenHashMap.this.mask;
                }
            }
            this.last = this.pos;
            if (this.c != 0) {
                boolean[] used = Char2ObjectOpenHashMap.this.used;
                while (this.pos-- != 0 && !used[this.pos]) {
                }
            }
            return this.last;
        }

        protected final int shiftKeys(int pos) {
            int last;
            while (true) {
                last = pos;
                pos = last + 1 & Char2ObjectOpenHashMap.this.mask;
                while (Char2ObjectOpenHashMap.this.used[pos]) {
                    int slot = HashCommon.murmurHash3(Char2ObjectOpenHashMap.this.key[pos] ^ Char2ObjectOpenHashMap.this.mask) & Char2ObjectOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Char2ObjectOpenHashMap.this.mask;
                }
                if (!Char2ObjectOpenHashMap.this.used[pos]) break;
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new CharArrayList();
                    }
                    this.wrapped.add(Char2ObjectOpenHashMap.this.key[pos]);
                }
                Char2ObjectOpenHashMap.this.key[last] = Char2ObjectOpenHashMap.this.key[pos];
                Char2ObjectOpenHashMap.this.value[last] = Char2ObjectOpenHashMap.this.value[pos];
            }
            Char2ObjectOpenHashMap.this.used[last] = false;
            Char2ObjectOpenHashMap.this.value[last] = null;
            return last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.pos < -1) {
                Char2ObjectOpenHashMap.this.remove(this.wrapped.getChar(-this.pos - 2));
                this.last = -1;
                return;
            }
            --Char2ObjectOpenHashMap.this.size;
            if (this.shiftKeys(this.last) == this.pos && this.c > 0) {
                ++this.c;
                this.nextEntry();
            }
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Char2ObjectMap.Entry<V>,
    Map.Entry<Character, V> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Character getKey() {
            return Character.valueOf(Char2ObjectOpenHashMap.this.key[this.index]);
        }

        @Override
        public char getCharKey() {
            return Char2ObjectOpenHashMap.this.key[this.index];
        }

        @Override
        public V getValue() {
            return Char2ObjectOpenHashMap.this.value[this.index];
        }

        @Override
        public V setValue(V v) {
            Object oldValue = Char2ObjectOpenHashMap.this.value[this.index];
            Char2ObjectOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Char2ObjectOpenHashMap.this.key[this.index] == ((Character)e.getKey()).charValue() && (Char2ObjectOpenHashMap.this.value[this.index] == null ? e.getValue() == null : Char2ObjectOpenHashMap.this.value[this.index].equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return Char2ObjectOpenHashMap.this.key[this.index] ^ (Char2ObjectOpenHashMap.this.value[this.index] == null ? 0 : Char2ObjectOpenHashMap.this.value[this.index].hashCode());
        }

        public String toString() {
            return Char2ObjectOpenHashMap.this.key[this.index] + "=>" + Char2ObjectOpenHashMap.this.value[this.index];
        }
    }
}

