/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.hexviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.apache.pdfbox.debugger.hexviewer.HexModel;
import org.apache.pdfbox.debugger.hexviewer.HexView;

class AddressPane
extends JComponent {
    private final int totalLine;
    private int selectedLine = -1;
    private int selectedIndex = -1;

    AddressPane(int total) {
        this.totalLine = total;
        this.setPreferredSize(new Dimension(120, 20 * (this.totalLine + 1)));
        this.setFont(HexView.FONT);
    }

    @Override
    protected void paintComponent(Graphics g2) {
        int firstLine;
        super.paintComponent(g2);
        Graphics2D g2d = (Graphics2D)g2;
        g2d.setRenderingHints(HexView.RENDERING_HINTS);
        Rectangle bound = this.getVisibleRect();
        int x = 20;
        int y = bound.y;
        if (y == 0 || y % 20 != 0) {
            y += 20 - y % 20;
        }
        for (int line = firstLine = y / 20; (double)line < (double)firstLine + bound.getHeight() / 20.0 && line <= this.totalLine; ++line) {
            if (line == this.selectedLine) {
                this.paintSelected(g2, x, y);
            } else {
                g2.drawString(String.format("%08X", (line - 1) * 16), x, y);
            }
            x = 20;
            y += 20;
        }
    }

    private void paintSelected(Graphics g2, int x, int y) {
        g2.setColor(HexView.SELECTED_COLOR);
        g2.setFont(HexView.BOLD_FONT);
        g2.drawString(String.format("%08X", this.selectedIndex), x, y);
        g2.setColor(Color.black);
        g2.setFont(HexView.FONT);
    }

    void setSelected(int index) {
        if (index != this.selectedIndex) {
            this.selectedLine = HexModel.lineNumber(index);
            this.selectedIndex = index;
            this.repaint();
        }
    }
}

