/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public final class ImageUtil {
    private ImageUtil() {
    }

    public static BufferedImage getRotatedImage(BufferedImage image, int rotation) {
        BufferedImage rotatedImage;
        int width = image.getWidth();
        int height = image.getHeight();
        int x = 0;
        int y = 0;
        switch ((rotation + 360) % 360) {
            case 0: {
                return image;
            }
            case 90: {
                x = height;
                rotatedImage = new BufferedImage(height, width, image.getType());
                break;
            }
            case 270: {
                y = width;
                rotatedImage = new BufferedImage(height, width, image.getType());
                break;
            }
            case 180: {
                x = width;
                y = height;
                rotatedImage = new BufferedImage(width, height, image.getType());
                break;
            }
            default: {
                throw new IllegalArgumentException("Only multiple of 90\u00b0 are supported");
            }
        }
        Graphics2D g2 = (Graphics2D)rotatedImage.getGraphics();
        g2.translate(x, y);
        g2.rotate(Math.toRadians(rotation));
        g2.drawImage((Image)image, 0, 0, null);
        g2.dispose();
        return rotatedImage;
    }
}

